/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.FallingBlockEntity;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.LightningEntity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.PaintingEntity;
import net.minecraft.core.entity.TNTPrimedEntity;
import net.minecraft.core.entity.animal.ChickenMob;
import net.minecraft.core.entity.animal.CowMob;
import net.minecraft.core.entity.animal.FireflyClusterMob;
import net.minecraft.core.entity.animal.PigMob;
import net.minecraft.core.entity.animal.SheepMob;
import net.minecraft.core.entity.animal.SquidMob;
import net.minecraft.core.entity.animal.WolfMob;
import net.minecraft.core.entity.monster.CreeperMob;
import net.minecraft.core.entity.monster.GhastMob;
import net.minecraft.core.entity.monster.GiantMob;
import net.minecraft.core.entity.monster.HumanMob;
import net.minecraft.core.entity.monster.ScorpionMob;
import net.minecraft.core.entity.monster.SkeletonMob;
import net.minecraft.core.entity.monster.SlimeMob;
import net.minecraft.core.entity.monster.SnowmanMob;
import net.minecraft.core.entity.monster.SpiderMob;
import net.minecraft.core.entity.monster.ZombieArmoredMob;
import net.minecraft.core.entity.monster.ZombieMob;
import net.minecraft.core.entity.monster.ZombiePigMob;
import net.minecraft.core.entity.projectile.ArrowProjectile;
import net.minecraft.core.entity.projectile.ArrowProjectileGolden;
import net.minecraft.core.entity.projectile.ArrowProjectilePurple;
import net.minecraft.core.entity.projectile.CannonballProjectile;
import net.minecraft.core.entity.projectile.FireballProjectile;
import net.minecraft.core.entity.projectile.PebbleProjectile;
import net.minecraft.core.entity.projectile.SnowballProjectile;
import net.minecraft.core.entity.vehicle.BoatEntity;
import net.minecraft.core.entity.vehicle.MinecartEntity;
import net.minecraft.core.world.World;

public class EntityDispatcher {
    public static final Map<String, Class<? extends Entity>> keyToClassMap = new HashMap<String, Class<? extends Entity>>();
    public static final Map<Class<? extends Entity>, String> classToKeyMap = new HashMap<Class<? extends Entity>, String>();
    private static final Map<Integer, Class<? extends Entity>> idToClassMap = new HashMap<Integer, Class<? extends Entity>>();
    private static final Map<Class<? extends Entity>, Integer> classToIdMap = new HashMap<Class<? extends Entity>, Integer>();

    public static void addMapping(Class<? extends Entity> clazz, String key, int id) {
        keyToClassMap.put(key, clazz);
        classToKeyMap.put(clazz, key);
        idToClassMap.put(id, clazz);
        classToIdMap.put(clazz, id);
    }

    public static Entity createEntityInWorld(String s, World world) {
        Entity entity = null;
        try {
            Class<? extends Entity> clazz = keyToClassMap.get(s);
            if (clazz != null) {
                entity = clazz.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error with id '" + s + "'");
        }
        return entity;
    }

    public static Entity createEntityFromNBT(CompoundTag compoundTag, World world) {
        Entity entity = null;
        try {
            Class<? extends Entity> clazz = keyToClassMap.get(compoundTag.getString("id"));
            if (clazz != null) {
                entity = clazz.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            entity.load(compoundTag);
        } else {
            System.out.println("Skipping Entity with id " + compoundTag.getString("id"));
        }
        return entity;
    }

    public static Entity createEntity(int id, World world) {
        Entity entity = null;
        try {
            Class<? extends Entity> clazz = idToClassMap.get(id);
            if (clazz != null) {
                entity = clazz.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            System.out.println("Skipping Entity with id " + id);
        }
        return entity;
    }

    public static int getEntityID(Entity entity) {
        return EntityDispatcher.getEntityID(entity.getClass());
    }

    public static int getEntityID(Class<? extends Entity> entityClass) {
        return classToIdMap.get(entityClass);
    }

    public static String getEncodeId(Entity entity) {
        return classToKeyMap.get(entity.getClass());
    }

    public static String getEncodeId(Class<? extends Entity> clazz) {
        return classToKeyMap.get(clazz);
    }

    public static Class<? extends Entity> getClassFromID(int id) {
        return idToClassMap.get(id);
    }

    public static Class<? extends Entity> getClassFromEncodeID(String encodeID) {
        return keyToClassMap.get(encodeID);
    }

    static {
        EntityDispatcher.addMapping(ItemEntity.class, "Item", 1);
        EntityDispatcher.addMapping(LightningEntity.class, "Lightning", 8);
        EntityDispatcher.addMapping(PaintingEntity.class, "Painting", 9);
        EntityDispatcher.addMapping(ArrowProjectile.class, "Arrow", 10);
        EntityDispatcher.addMapping(SnowballProjectile.class, "Snowball", 11);
        EntityDispatcher.addMapping(FireballProjectile.class, "Fireball", 12);
        EntityDispatcher.addMapping(TNTPrimedEntity.class, "PrimedTnt", 20);
        EntityDispatcher.addMapping(FallingBlockEntity.class, "FallingSand", 21);
        EntityDispatcher.addMapping(MinecartEntity.class, "Minecart", 40);
        EntityDispatcher.addMapping(BoatEntity.class, "Boat", 41);
        EntityDispatcher.addMapping(ZombieArmoredMob.class, "ArmouredZombie", 42);
        EntityDispatcher.addMapping(ArrowProjectileGolden.class, "ArrowGolden", 43);
        EntityDispatcher.addMapping(CannonballProjectile.class, "Cannonball", 44);
        EntityDispatcher.addMapping(ArrowProjectilePurple.class, "ArrowPurple", 45);
        EntityDispatcher.addMapping(PebbleProjectile.class, "Pebble", 46);
        EntityDispatcher.addMapping(FireflyClusterMob.class, "FireflyCluster", 47);
        EntityDispatcher.addMapping(Mob.class, "Mob", 48);
        EntityDispatcher.addMapping(HumanMob.class, "Monster", 49);
        EntityDispatcher.addMapping(CreeperMob.class, "Creeper", 50);
        EntityDispatcher.addMapping(SkeletonMob.class, "Skeleton", 51);
        EntityDispatcher.addMapping(SpiderMob.class, "Spider", 52);
        EntityDispatcher.addMapping(GiantMob.class, "Giant", 53);
        EntityDispatcher.addMapping(ZombieMob.class, "Zombie", 54);
        EntityDispatcher.addMapping(SlimeMob.class, "Slime", 55);
        EntityDispatcher.addMapping(GhastMob.class, "Ghast", 56);
        EntityDispatcher.addMapping(ZombiePigMob.class, "PigZombie", 57);
        EntityDispatcher.addMapping(SnowmanMob.class, "Snowman", 58);
        EntityDispatcher.addMapping(ScorpionMob.class, "Scorpion", 59);
        EntityDispatcher.addMapping(PigMob.class, "Pig", 90);
        EntityDispatcher.addMapping(SheepMob.class, "Sheep", 91);
        EntityDispatcher.addMapping(CowMob.class, "Cow", 92);
        EntityDispatcher.addMapping(ChickenMob.class, "Chicken", 93);
        EntityDispatcher.addMapping(SquidMob.class, "Squid", 94);
        EntityDispatcher.addMapping(WolfMob.class, "Wolf", 95);
    }
}

