/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.entity.LightningEntity;
import net.minecraft.core.entity.animal.Animal;
import net.minecraft.core.entity.monster.ZombiePigMob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;

public class PigMob
extends Animal {
    public static final int DATA_SADDLE_ID = 16;
    public List<WeightedRandomLootObject> burningMobDrops = new ArrayList<WeightedRandomLootObject>();

    public PigMob(World world) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "pig");
        this.setSize(0.9f, 0.9f);
        this.mobDrops.add(new WeightedRandomLootObject(Items.FOOD_PORKCHOP_RAW.getDefaultStack(), 1, 2));
        this.burningMobDrops.add(new WeightedRandomLootObject(Items.FOOD_PORKCHOP_COOKED.getDefaultStack(), 1, 2));
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(16, (byte)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Saddle", this.getSaddled());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSaddled(tag.getBoolean("Saddle"));
    }

    @Override
    public String getLivingSound() {
        return "mob.pig";
    }

    @Override
    protected String getHurtSound() {
        return "mob.pig";
    }

    @Override
    protected String getDeathSound() {
        return "mob.pigdeath";
    }

    @Override
    public boolean interact(Player entityplayer) {
        if (super.interact(entityplayer)) {
            return true;
        }
        if (this.getSaddled() && !this.world.isClientSide && (this.passenger == null || this.passenger == entityplayer)) {
            entityplayer.startRiding(this);
            return true;
        }
        return false;
    }

    @Override
    protected void dropDeathItems() {
        if (this.getSaddled()) {
            this.spawnAtLocation(Items.SADDLE.id, 1);
        }
        super.dropDeathItems();
    }

    @Override
    protected List<WeightedRandomLootObject> getMobDrops() {
        if (this.remainingFireTicks > 0) {
            return this.burningMobDrops;
        }
        return this.mobDrops;
    }

    public boolean getSaddled() {
        return (this.entityData.getByte(16) & 1) != 0;
    }

    public void setSaddled(boolean flag) {
        if (flag) {
            this.entityData.set(16, (byte)1);
        } else {
            this.entityData.set(16, (byte)0);
        }
    }

    @Override
    public void thunderHit(LightningEntity bolt) {
        if (!this.world.isClientSide) {
            ZombiePigMob entitypigzombie = new ZombiePigMob(this.world);
            entitypigzombie.moveTo(this.x, this.y, this.z, this.yRot, this.xRot);
            this.world.entityJoinedWorld(entitypigzombie);
            this.remove();
        }
    }

    @Override
    protected void causeFallDamage(float distance) {
        super.causeFallDamage(distance);
        if (distance > 5.0f && this.passenger instanceof Player) {
            ((Player)this.passenger).triggerAchievement(Achievements.FLY_PIG);
        }
    }
}

