/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ArrowProjectile;
import net.minecraft.core.entity.projectile.ArrowProjectileGolden;
import net.minecraft.core.entity.projectile.ArrowProjectilePurple;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;

public class BowItem
extends Item {
    public BowItem(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 1;
        this.setMaxDamage(384);
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        ItemStack quiverSlot = entityplayer.inventory.armorItemInSlot(2);
        if (quiverSlot != null && quiverSlot.itemID == Items.ARMOR_QUIVER.id && quiverSlot.getMetadata() < quiverSlot.getMaxDamage()) {
            entityplayer.inventory.armorItemInSlot(2).damageItem(1, entityplayer);
            itemstack.damageItem(1, entityplayer);
            world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                world.entityJoinedWorld(new ArrowProjectile(world, entityplayer, true, 0));
            }
        } else if (quiverSlot != null && quiverSlot.itemID == Items.ARMOR_QUIVER_GOLD.id) {
            itemstack.damageItem(1, entityplayer);
            world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                world.entityJoinedWorld(new ArrowProjectilePurple(world, entityplayer, false));
            }
        } else if (entityplayer.inventory.consumeInventoryItem(Items.AMMO_ARROW_GOLD.id)) {
            itemstack.damageItem(1, entityplayer);
            world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                world.entityJoinedWorld(new ArrowProjectileGolden(world, entityplayer, true));
            }
        } else if (entityplayer.inventory.consumeInventoryItem(Items.AMMO_ARROW.id)) {
            itemstack.damageItem(1, entityplayer);
            world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                world.entityJoinedWorld(new ArrowProjectile(world, entityplayer, true, 0));
            }
        }
        return itemstack;
    }
}

