/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.LocalPlayer;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.world.World;

public class ClientPlayerCommandSender
extends PlayerCommandSender {
    public final Minecraft minecraft;
    public final LocalPlayer player;

    public ClientPlayerCommandSender(Minecraft minecraft, LocalPlayer player) {
        if (minecraft == null) {
            throw new NullPointerException();
        }
        this.minecraft = minecraft;
        this.player = player;
    }

    @Override
    public boolean isAdmin() {
        return this.minecraft.theWorld.getLevelData().getCheatsEnabled();
    }

    @Override
    public void sendMessage(String string) {
        this.minecraft.ingameGUI.addChatMessage(string);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public String getName() {
        return this.player.getDisplayName();
    }

    @Override
    public World getWorld() {
        return this.minecraft.theWorld;
    }
}

