/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.servercommands;

import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;

public class ColorCommand
extends ServerCommand {
    public ColorCommand(MinecraftServer server) {
        super(server, "color", "colour", "c");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        byte newColor;
        int i;
        if (!sender.isPlayer()) {
            throw new CommandError("Must be used by a player!");
        }
        ServerPlayer player = (ServerPlayer)sender.getPlayer();
        if (args.length == 0) {
            TextFormatting color = TextFormatting.get(player.chatColor);
            sender.sendMessage(TextFormatting.LIGHT_GRAY + "Your color is " + color + color.getNames()[0]);
            StringBuilder builder = new StringBuilder();
            builder.append(TextFormatting.LIGHT_GRAY + "Available colors: ");
            int c = 0;
            for (int i2 = 0; i2 < 16; ++i2) {
                TextFormatting color2 = TextFormatting.get(i2);
                if (c > 0) {
                    builder.append(", ");
                }
                builder.append(color2).append(color2.getNames()[0]);
                ++c;
            }
            sender.sendMessage(builder.toString());
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("set")) {
            String[] args2 = new String[args.length - 1];
            for (i = 1; i < args.length; ++i) {
                args2[i - 1] = args[i];
            }
            args = args2;
        }
        StringBuilder enteredColorStr = new StringBuilder();
        for (i = 0; i < args.length; ++i) {
            enteredColorStr.append(args[i].toLowerCase());
        }
        String enteredColor = enteredColorStr.toString();
        TextFormatting color = TextFormatting.getColorFormatting(enteredColor);
        if (color == null) {
            throw new CommandError("Can't find color: \"" + enteredColor + "\"");
        }
        player.chatColor = newColor = (byte)color.id;
        player.hadNicknameSet = true;
        player.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(player.username, player.nickname, player.score, newColor, true, player.isOperator()));
        sender.sendMessage(TextFormatting.LIGHT_GRAY + "You changed your color to " + color + color.getNames()[0]);
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/color");
        sender.sendMessage("/color <color>");
    }
}

