/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.entity.entries;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.projectile.ArrowProjectile;
import net.minecraft.core.entity.projectile.ArrowProjectileGolden;
import net.minecraft.core.entity.projectile.ArrowProjectilePurple;
import net.minecraft.core.net.entity.ITrackedEntry;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.packet.AddEntityPacket;
import net.minecraft.core.world.World;
import net.minecraft.server.entity.EntityTracker;
import net.minecraft.server.entity.EntityTrackerEntry;
import org.jetbrains.annotations.NotNull;

public class ArrowNetEntry
implements IVehicleEntry<ArrowProjectile>,
ITrackedEntry<ArrowProjectile> {
    @Override
    @NotNull
    public Class<ArrowProjectile> getAppliedClass() {
        return ArrowProjectile.class;
    }

    @Override
    public int getTrackingDistance() {
        return 64;
    }

    @Override
    public int getPacketDelay() {
        return 20;
    }

    @Override
    public boolean sendMotionUpdates() {
        return false;
    }

    @Override
    public void onEntityTracked(EntityTracker tracker, EntityTrackerEntry trackerEntry, ArrowProjectile trackedObject) {
    }

    @Override
    public Entity getEntity(World world, double x, double y, double z, int metadata, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        if (metadata == 2) {
            return new ArrowProjectileGolden(world, x, y, z);
        }
        if (metadata == 1) {
            return new ArrowProjectilePurple(world, x, y, z);
        }
        return new ArrowProjectile(world, x, y, z, metadata);
    }

    @Override
    public AddEntityPacket getSpawnPacket(EntityTrackerEntry tracker, ArrowProjectile trackedObject) {
        Mob entityliving = trackedObject.owner;
        return new AddEntityPacket(trackedObject, trackedObject.getArrowType(), entityliving == null ? -1 : entityliving.id, trackedObject.xd, trackedObject.yd, trackedObject.zd);
    }
}

