/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.slot;

import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.block.BlockItem;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.Inventory;
import net.minecraft.core.player.inventory.menu.InventoryMenu;
import net.minecraft.core.player.inventory.slot.Slot;

public class ArmorSlot
extends Slot {
    public static String[] armorOutlines = new String[]{"minecraft:item/armor_helmet_outline", "minecraft:item/armor_chestplate_outline", "minecraft:item/armor_leggings_outline", "minecraft:item/armor_boots_outline"};
    final int armorType;
    final InventoryMenu menu;

    public ArmorSlot(InventoryMenu menu, Container container, int index, int x, int y, int armorType) {
        super(container, index, x, y);
        this.menu = menu;
        this.armorType = armorType;
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean mayPlace(ItemStack itemstack) {
        if (itemstack.getItem() instanceof IArmorItem) {
            return ((IArmorItem)((Object)itemstack.getItem())).getArmorPiece() == this.armorType;
        }
        if (itemstack.getItem() instanceof BlockItem) {
            return this.armorType == 0;
        }
        return false;
    }

    @Override
    public void setChanged() {
        super.setChanged();
        int count = 0;
        for (int i = 0; i < this.menu.slots.size(); ++i) {
            ItemStack stack;
            if (!(this.menu.slots.get(i) instanceof ArmorSlot) || (stack = ((Slot)this.menu.slots.get(i)).getItem()) == null || stack.itemID != Items.ARMOR_BOOTS_CHAINMAIL.id && stack.itemID != Items.ARMOR_HELMET_CHAINMAIL.id && stack.itemID != Items.ARMOR_CHESTPLATE_CHAINMAIL.id && stack.itemID != Items.ARMOR_LEGGINGS_CHAINMAIL.id) continue;
            ++count;
        }
        if (count == 4) {
            this.menu.inventory.player.triggerAchievement(Achievements.GET_CHAINMAIL);
        }
        if (this.getItem() != null && this.container instanceof Inventory) {
            Player player = ((Inventory)this.container).player;
            player.world.playSoundAtEntity(player, player, "random.equip", 2.0f, 1.0f);
        }
    }

    @Override
    public void set(ItemStack itemstack) {
        super.set(itemstack);
    }

    @Override
    public String getItemIcon() {
        return armorOutlines[this.armorType];
    }
}

