/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.net.handler.LoginPacketHandler;
import net.minecraft.server.net.handler.ServerPacketHandler;
import org.apache.log4j.Logger;

public class NetworkListenThread {
    public static Logger logger = Logger.getLogger((String)"Minecraft");
    private ServerSocket serverSocket;
    private Thread networkAcceptThread;
    public volatile boolean isListening = false;
    private int connectionCounter = 0;
    private ArrayList<LoginPacketHandler> pendingConnections = new ArrayList();
    private final ArrayList<ServerPacketHandler> playerList = new ArrayList();
    public MinecraftServer mcServer;

    public NetworkListenThread(MinecraftServer minecraftserver, InetAddress addr, int i) throws IOException {
        this.mcServer = minecraftserver;
        this.serverSocket = new ServerSocket(i, 0, addr);
        this.serverSocket.setPerformancePreferences(0, 2, 1);
        this.isListening = true;
        this.networkAcceptThread = new Thread(() -> {
            while (this.isListening) {
                try {
                    Socket socket = this.serverSocket.accept();
                    if (socket == null) continue;
                    LoginPacketHandler loginHandler = new LoginPacketHandler(this.mcServer, socket, "Connection #" + this.connectionCounter++);
                    this.addPendingConnection(loginHandler);
                }
                catch (IOException ioexception) {
                    ioexception.printStackTrace();
                }
            }
        });
        this.networkAcceptThread.start();
    }

    public void addPlayer(ServerPacketHandler netserverhandler) {
        this.playerList.add(netserverhandler);
    }

    private void addPendingConnection(LoginPacketHandler netloginhandler) {
        if (netloginhandler == null) {
            throw new IllegalArgumentException("Got null pendingconnection!");
        }
        this.pendingConnections.add(netloginhandler);
    }

    public void handleNetworkListenThread() {
        for (int i = 0; i < this.pendingConnections.size(); ++i) {
            LoginPacketHandler netloginhandler = this.pendingConnections.get(i);
            try {
                netloginhandler.tryLogin();
            }
            catch (Exception exception) {
                netloginhandler.kickUser("Internal server error");
                logger.warn((Object)("Failed to handle packet: " + exception), (Throwable)exception);
            }
            if (netloginhandler.finishedProcessing) {
                this.pendingConnections.remove(i--);
            }
            netloginhandler.netManager.wakeThreads();
        }
        for (int j = 0; j < this.playerList.size(); ++j) {
            ServerPacketHandler netserverhandler = this.playerList.get(j);
            try {
                netserverhandler.handlePackets();
            }
            catch (Exception exception1) {
                logger.warn((Object)("Failed to handle packet: " + exception1), (Throwable)exception1);
                netserverhandler.kickPlayer("Internal server error");
            }
            if (netserverhandler.connectionClosed) {
                this.playerList.remove(j--);
            }
            netserverhandler.netManager.wakeThreads();
        }
    }
}

