/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import com.github.zarzelcow.legacylwjgl3.implementation.LWJGLImplementationUtils;
import com.github.zarzelcow.legacylwjgl3.implementation.input.InputImplementation;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;

public class Mouse {
    public static final int EVENT_SIZE = 22;
    private static boolean created;
    private static ByteBuffer buttons;
    private static int x;
    private static int y;
    private static int absolute_x;
    private static int absolute_y;
    private static IntBuffer coord_buffer;
    private static int dx;
    private static int dy;
    private static int dwheel;
    private static int buttonCount;
    private static boolean hasWheel;
    private static String[] buttonName;
    private static final Map<String, Integer> buttonMap;
    private static boolean initialized;
    private static ByteBuffer readBuffer;
    private static int eventButton;
    private static boolean eventState;
    private static int event_dx;
    private static int event_dy;
    private static int event_dwheel;
    private static int event_x;
    private static int event_y;
    private static long event_nanos;
    private static int grab_x;
    private static int grab_y;
    private static int last_event_raw_x;
    private static int last_event_raw_y;
    private static final int BUFFER_SIZE = 50;
    private static boolean isGrabbed;
    private static InputImplementation implementation;
    private static boolean clipMouseCoordinatesToWindow;

    private Mouse() {
    }

    public static boolean isClipMouseCoordinatesToWindow() {
        return clipMouseCoordinatesToWindow;
    }

    public static void setClipMouseCoordinatesToWindow(boolean clip) {
        clipMouseCoordinatesToWindow = clip;
    }

    public static void setCursorPosition(int new_x, int new_y) {
        if (!Mouse.isCreated()) {
            throw new IllegalStateException("Mouse is not created");
        }
        x = event_x = new_x;
        y = event_y = new_y;
        if (!Mouse.isGrabbed()) {
            implementation.setCursorPosition(x, y);
        } else {
            grab_x = new_x;
            grab_y = new_y;
        }
    }

    private static void initialize() {
        Sys.initialize();
        buttonName = new String[16];
        for (int i = 0; i < 16; ++i) {
            Mouse.buttonName[i] = "BUTTON" + i;
            buttonMap.put(buttonName[i], i);
        }
        initialized = true;
    }

    private static void resetMouse() {
        dwheel = 0;
        dy = 0;
        dx = 0;
        readBuffer.position(readBuffer.limit());
    }

    static InputImplementation getImplementation() {
        return implementation;
    }

    private static void create(InputImplementation impl) throws LWJGLException {
        if (created) {
            return;
        }
        if (!initialized) {
            Mouse.initialize();
        }
        implementation = impl;
        implementation.createMouse();
        hasWheel = implementation.hasWheel();
        created = true;
        buttonCount = implementation.getButtonCount();
        buttons = BufferUtils.createByteBuffer((int)buttonCount);
        coord_buffer = BufferUtils.createIntBuffer((int)3);
        readBuffer = ByteBuffer.allocate(1100);
        readBuffer.limit(0);
        Mouse.setGrabbed(isGrabbed);
    }

    public static void create() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display must be created.");
        }
        Mouse.create(LWJGLImplementationUtils.getOrCreateInputImplementation());
    }

    public static boolean isCreated() {
        return created;
    }

    public static void destroy() {
        if (!created) {
            return;
        }
        created = false;
        buttons = null;
        coord_buffer = null;
        implementation.destroyMouse();
    }

    public static void poll() {
        if (!created) {
            throw new IllegalStateException("Mouse must be created before you can poll it");
        }
        implementation.pollMouse(coord_buffer, buttons);
        int poll_coord1 = coord_buffer.get(0);
        int poll_coord2 = coord_buffer.get(1);
        int poll_dwheel = coord_buffer.get(2);
        if (Mouse.isGrabbed()) {
            dx += poll_coord1;
            dy += poll_coord2;
            x += poll_coord1;
            y += poll_coord2;
            absolute_x += poll_coord1;
            absolute_y += poll_coord2;
        } else {
            dx = poll_coord1 - absolute_x;
            dy = poll_coord2 - absolute_y;
            absolute_x = x = poll_coord1;
            absolute_y = y = poll_coord2;
        }
        if (clipMouseCoordinatesToWindow) {
            x = Math.min(Display.getWidth() - 1, Math.max(0, x));
            y = Math.min(Display.getHeight() - 1, Math.max(0, y));
        }
        dwheel += poll_dwheel;
        Mouse.read();
    }

    private static void read() {
        readBuffer.compact();
        implementation.readMouse(readBuffer);
        readBuffer.flip();
    }

    public static boolean isButtonDown(int button) {
        if (!created) {
            throw new IllegalStateException("Mouse must be created before you can poll the button state");
        }
        if (button >= buttonCount || button < 0) {
            return false;
        }
        return buttons.get(button) == 1;
    }

    public static String getButtonName(int button) {
        if (button >= buttonName.length || button < 0) {
            return null;
        }
        return buttonName[button];
    }

    public static int getButtonIndex(String buttonName) {
        Integer ret = buttonMap.get(buttonName);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    public static boolean next() {
        if (!created) {
            throw new IllegalStateException("Mouse must be created before you can read events");
        }
        if (readBuffer.hasRemaining()) {
            eventButton = readBuffer.get();
            boolean bl = eventState = readBuffer.get() != 0;
            if (Mouse.isGrabbed()) {
                event_dx = readBuffer.getInt();
                event_dy = readBuffer.getInt();
                last_event_raw_x = event_x += event_dx;
                last_event_raw_y = event_y += event_dy;
            } else {
                int new_event_x = readBuffer.getInt();
                int new_event_y = readBuffer.getInt();
                event_dx = new_event_x - last_event_raw_x;
                event_dy = new_event_y - last_event_raw_y;
                event_x = new_event_x;
                event_y = new_event_y;
                last_event_raw_x = new_event_x;
                last_event_raw_y = new_event_y;
            }
            if (clipMouseCoordinatesToWindow) {
                event_x = Math.min(Display.getWidth() - 1, Math.max(0, event_x));
                event_y = Math.min(Display.getHeight() - 1, Math.max(0, event_y));
            }
            event_dwheel = readBuffer.getInt();
            event_nanos = readBuffer.getLong();
            return true;
        }
        return false;
    }

    public static int getEventButton() {
        return eventButton;
    }

    public static boolean getEventButtonState() {
        return eventState;
    }

    public static int getEventDX() {
        return event_dx;
    }

    public static int getEventDY() {
        return event_dy;
    }

    public static int getEventX() {
        return event_x;
    }

    public static int getEventY() {
        return event_y;
    }

    public static int getEventDWheel() {
        return event_dwheel;
    }

    public static long getEventNanoseconds() {
        return event_nanos;
    }

    public static int getX() {
        return x;
    }

    public static int getY() {
        return y;
    }

    public static int getDX() {
        int result = dx;
        dx = 0;
        return result;
    }

    public static int getDY() {
        int result = dy;
        dy = 0;
        return result;
    }

    public static int getDWheel() {
        int result = dwheel;
        dwheel = 0;
        return result;
    }

    public static int getButtonCount() {
        return buttonCount;
    }

    public static boolean hasWheel() {
        return hasWheel;
    }

    public static boolean isGrabbed() {
        return isGrabbed;
    }

    public static void setGrabbed(boolean grab) {
        boolean grabbed = isGrabbed;
        isGrabbed = grab;
        if (Mouse.isCreated()) {
            if (grab && !grabbed) {
                grab_x = x;
                grab_y = y;
            } else if (!grab && grabbed) {
                implementation.setCursorPosition(grab_x, grab_y);
            }
            implementation.grabMouse(grab);
            Mouse.poll();
            event_x = x;
            event_y = y;
            last_event_raw_x = x;
            last_event_raw_y = y;
            Mouse.resetMouse();
        }
    }

    public static boolean getPrivilegedBoolean(String property_name) {
        return Boolean.getBoolean(property_name);
    }

    public static boolean isInsideWindow() {
        return implementation.isInsideWindow();
    }

    static {
        buttonCount = -1;
        buttonMap = new HashMap<String, Integer>(16);
        clipMouseCoordinatesToWindow = !Mouse.getPrivilegedBoolean("org.lwjgl.input.Mouse.allowNegativeMouseCoords");
    }
}

