/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.system.Struct;

public abstract class Display {
    private static String title = "";
    private static long handle = -1L;
    private static boolean resizable = false;
    private static DisplayMode displayMode = new DisplayMode(640, 480, 24, 60);
    private static int width = 0;
    private static int height = 0;
    private static int xPos = 0;
    private static int yPos = 0;
    private static boolean windowResized = false;
    private static GLFWWindowSizeCallback sizeCallback = null;
    private static ByteBuffer[] cachedIcons = null;
    private static Canvas parent = null;

    public static void create() throws LWJGLException {
        Display.create(new PixelFormat());
    }

    public static long getHandle() {
        return handle;
    }

    public static void create(PixelFormat pixel_format) throws LWJGLException {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)(resizable ? 1 : 0));
        handle = GLFW.glfwCreateWindow((int)displayMode.getWidth(), (int)displayMode.getHeight(), (CharSequence)title, (long)0L, (long)0L);
        width = displayMode.getWidth();
        height = displayMode.getHeight();
        GLFW.glfwMakeContextCurrent((long)handle);
        GL.createCapabilities();
        sizeCallback = GLFWWindowSizeCallback.create(Display::resizeCallback);
        GLFW.glfwSetWindowSizeCallback((long)handle, (GLFWWindowSizeCallbackI)sizeCallback);
        Mouse.create();
        Keyboard.create();
        GLFW.glfwShowWindow((long)handle);
        if (cachedIcons != null) {
            Display.setIcon(cachedIcons);
        }
    }

    private static void resizeCallback(long window, int width, int height) {
        if (window == handle) {
            Display.width = width;
            Display.height = height;
            windowResized = true;
        }
    }

    private static void destroyWindow() {
        sizeCallback.free();
        Mouse.destroy();
        Keyboard.destroy();
        GLFW.glfwDestroyWindow((long)handle);
    }

    public static void destroy() {
        Display.destroyWindow();
        GLFW.glfwTerminate();
        GLFW.glfwSetErrorCallback(null).free();
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
        if (primaryMonitor == 0L) {
            return new DisplayMode[0];
        }
        GLFWVidMode.Buffer videoModes = GLFW.glfwGetVideoModes((long)primaryMonitor);
        if (videoModes == null) {
            return new DisplayMode[0];
        }
        DisplayMode[] modes = new DisplayMode[videoModes.capacity()];
        for (int i = 0; i < videoModes.capacity(); ++i) {
            GLFWVidMode videoMode = (GLFWVidMode)videoModes.get(i);
            modes[i] = new DisplayMode(videoMode.width(), videoMode.height(), videoMode.redBits() + videoMode.greenBits() + videoMode.blueBits(), videoMode.refreshRate());
        }
        return modes;
    }

    public static DisplayMode getDesktopDisplayMode() {
        GLFWVidMode videoMode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
        if (videoMode == null) {
            DisplayMode[] displayModes = Display.getAvailableDisplayModes();
            if (displayModes.length == 0) {
                return null;
            }
            DisplayMode largest = displayModes[0];
            for (DisplayMode mode : displayModes) {
                if (mode.getWidth() * mode.getHeight() <= largest.getWidth() * largest.getHeight()) continue;
                largest = mode;
            }
            return largest;
        }
        return new DisplayMode(videoMode.width(), videoMode.height(), videoMode.redBits() + videoMode.greenBits() + videoMode.blueBits(), videoMode.refreshRate());
    }

    public static DisplayMode getDisplayMode() {
        return displayMode;
    }

    public static int getHeight() {
        return height;
    }

    public static Canvas getParent() {
        return parent;
    }

    public static String getTitle() {
        return title;
    }

    public static int getWidth() {
        return width;
    }

    public static int getX() {
        return xPos;
    }

    public static int getY() {
        return yPos;
    }

    public static boolean isActive() {
        return GLFW.glfwGetWindowAttrib((long)handle, (int)131073) == 1;
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose((long)handle);
    }

    public static boolean isCreated() {
        return handle != -1L;
    }

    public static boolean isFullscreen() {
        return GLFW.glfwGetWindowMonitor((long)handle) != 0L;
    }

    public static boolean isResizable() {
        return resizable;
    }

    public static boolean isVisible() {
        return GLFW.glfwGetWindowAttrib((long)handle, (int)131076) == 1;
    }

    public static void setDisplayMode(DisplayMode mode) throws LWJGLException {
        displayMode = mode;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowSize((long)handle, (int)mode.getWidth(), (int)mode.getHeight());
        }
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) throws LWJGLException {
        Display.setDisplayMode(mode);
        Display.setFullscreen(true);
    }

    public static void setFullscreen(boolean fullscreen) throws LWJGLException {
        try {
            Display.resizeCallback(handle, displayMode.getWidth(), displayMode.getHeight());
            if (fullscreen) {
                long monitor = GLFW.glfwGetPrimaryMonitor();
                GLFW.glfwSetWindowMonitor((long)handle, (long)monitor, (int)0, (int)0, (int)Display.getWidth(), (int)Display.getHeight(), (int)displayMode.getFrequency());
                xPos = displayMode.getWidth() / 2;
                yPos = displayMode.getHeight() / 2;
            } else {
                GLFW.glfwSetWindowMonitor((long)handle, (long)0L, (int)(xPos -= width / 2), (int)(yPos -= height / 2), (int)Display.getWidth(), (int)Display.getHeight(), (int)-1);
            }
            GLFW.glfwSetWindowSize((long)handle, (int)Display.getWidth(), (int)Display.getHeight());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (Display.isCreated()) {
            GLFW.glfwSetWindowIcon((long)handle, (GLFWImage.Buffer)Display.iconsToGLFWBuffer(icons));
            return 1;
        }
        return 0;
    }

    private static ByteBuffer cloneByteBuffer(ByteBuffer original) {
        ByteBuffer clone = BufferUtils.createByteBuffer((int)original.capacity());
        int oldPosition = original.position();
        clone.put(original);
        ((Buffer)original).position(oldPosition);
        ((Buffer)clone).flip();
        return clone;
    }

    private static GLFWImage.Buffer iconsToGLFWBuffer(ByteBuffer[] icons) {
        GLFWImage.Buffer buffer = GLFWImage.create((int)icons.length);
        for (ByteBuffer icon : icons) {
            int size = icon.limit() / 4;
            int dimension = (int)Math.sqrt(size);
            GLFWImage image = GLFWImage.malloc();
            buffer.put((Struct)image.set(dimension, dimension, icon));
        }
        buffer.flip();
        return buffer;
    }

    public static void setLocation(int x, int y) {
        xPos = x;
        yPos = y;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowPos((long)handle, (int)x, (int)y);
        }
    }

    public static void setParent(Canvas parent) throws LWJGLException {
        Display.parent = parent;
    }

    public static void setResizable(boolean resizable) {
        Display.resizable = resizable;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowAttrib((long)handle, (int)131075, (int)(resizable ? 1 : 0));
        }
    }

    public static void setSwapInterval(int interval) {
        GLFW.glfwSwapInterval((int)interval);
    }

    public static void setTitle(String title) {
        Display.title = title;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowTitle((long)handle, (CharSequence)title);
        }
    }

    public static void setVSyncEnabled(boolean sync) {
        Display.setSwapInterval(sync ? 1 : 0);
    }

    public static void swapBuffers() throws LWJGLException {
        GLFW.glfwSwapBuffers((long)handle);
    }

    public static void update() {
        windowResized = false;
        GLFW.glfwPollEvents();
        if (Mouse.isCreated()) {
            Mouse.poll();
        }
        if (Keyboard.isCreated()) {
            Keyboard.poll();
        }
        GLFW.glfwSwapBuffers((long)handle);
    }

    public static boolean wasResized() {
        return windowResized;
    }
}

