/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StringTag
extends Tag<String> {
    public StringTag() {
        this.setValue("");
    }

    public StringTag(String value) {
        super(value);
        if (value == null) {
            throw new IllegalArgumentException("Empty string not allowed");
        }
    }

    @Override
    void write(DataOutput dos) throws IOException {
        dos.writeUTF((String)this.getValue());
    }

    @Override
    void read(DataInput dis) throws IOException {
        this.setValue(dis.readUTF());
    }

    @Override
    public byte getId() {
        return 8;
    }

    public String toString() {
        return "\"" + this.getTagName() + "\": \"" + (String)this.getValue() + "\"";
    }
}

