/*
 * Decompiled with CFR 0.152.
 */
package net.betterthanadventure.sound;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import net.betterthanadventure.sound.LibraryLWJGL3OpenAL;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import paulscode.sound.Channel;

public class ChannelLWJGL3OpenAL
extends Channel {
    public IntBuffer ALSource;
    public int ALformat;
    public int sampleRate;
    ByteBuffer bufferBuffer = BufferUtils.createByteBuffer((int)0x500000);

    public ChannelLWJGL3OpenAL(int var1, IntBuffer var2) {
        super(var1);
        this.libraryType = LibraryLWJGL3OpenAL.class;
        this.ALSource = var2;
    }

    public void cleanup() {
        if (this.ALSource != null) {
            try {
                AL10.alSourceStopv((IntBuffer)this.ALSource);
                AL10.alGetError();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                AL10.alDeleteSources((IntBuffer)this.ALSource);
                AL10.alGetError();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ALSource.clear();
        }
        this.ALSource = null;
        super.cleanup();
    }

    public boolean attachBuffer(IntBuffer var1) {
        if (this.errorCheck(this.channelType != 0, "Sound buffers may only be attached to normal sources.")) {
            return false;
        }
        AL10.alSourcei((int)this.ALSource.get(0), (int)4105, (int)var1.get(0));
        return this.checkALError();
    }

    public void setAudioFormat(AudioFormat var1) {
        int var3;
        boolean var2 = false;
        if (var1.getChannels() == 1) {
            if (var1.getSampleSizeInBits() == 8) {
                var3 = 4352;
            } else {
                if (var1.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'setAudioFormat'");
                    return;
                }
                var3 = 4353;
            }
        } else {
            if (var1.getChannels() != 2) {
                this.errorMessage("Audio data neither mono nor stereo in method 'setAudioFormat'");
                return;
            }
            if (var1.getSampleSizeInBits() == 8) {
                var3 = 4354;
            } else {
                if (var1.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'setAudioFormat'");
                    return;
                }
                var3 = 4355;
            }
        }
        this.ALformat = var3;
        this.sampleRate = (int)var1.getSampleRate();
    }

    public void setFormat(int var1, int var2) {
        this.ALformat = var1;
        this.sampleRate = var2;
    }

    public boolean preLoadBuffers(LinkedList var1) {
        IntBuffer var2;
        int var4;
        if (this.errorCheck(this.channelType != 1, "Buffers may only be queued for streaming sources.")) {
            return false;
        }
        if (this.errorCheck(var1 == null, "Buffer List null in method 'preLoadBuffers'")) {
            return false;
        }
        boolean var3 = this.playing();
        if (var3) {
            AL10.alSourceStop((int)this.ALSource.get(0));
            this.checkALError();
        }
        if ((var4 = AL10.alGetSourcei((int)this.ALSource.get(0), (int)4118)) > 0) {
            var2 = BufferUtils.createIntBuffer((int)var4);
            AL10.alGenBuffers((IntBuffer)var2);
            if (this.errorCheck(this.checkALError(), "Error clearing stream buffers in method 'preLoadBuffers'")) {
                return false;
            }
            AL10.alSourceUnqueueBuffers((int)this.ALSource.get(0), (IntBuffer)var2);
            if (this.errorCheck(this.checkALError(), "Error unqueuing stream buffers in method 'preLoadBuffers'")) {
                return false;
            }
        }
        if (var3) {
            AL10.alSourcePlay((int)this.ALSource.get(0));
            this.checkALError();
        }
        var2 = BufferUtils.createIntBuffer((int)var1.size());
        AL10.alGenBuffers((IntBuffer)var2);
        if (this.errorCheck(this.checkALError(), "Error generating stream buffers in method 'preLoadBuffers'")) {
            return false;
        }
        for (int var5 = 0; var5 < var1.size(); ++var5) {
            this.bufferBuffer.clear();
            this.bufferBuffer.put((byte[])var1.get(var5), 0, ((byte[])var1.get(var5)).length);
            this.bufferBuffer.flip();
            try {
                AL10.alBufferData((int)var2.get(var5), (int)this.ALformat, (ByteBuffer)this.bufferBuffer, (int)this.sampleRate);
            }
            catch (Exception var8) {
                this.errorMessage("Error creating buffers in method 'preLoadBuffers'");
                this.printStackTrace(var8);
                return false;
            }
            if (!this.errorCheck(this.checkALError(), "Error creating buffers in method 'preLoadBuffers'")) continue;
            return false;
        }
        try {
            AL10.alSourceQueueBuffers((int)this.ALSource.get(0), (IntBuffer)var2);
        }
        catch (Exception var7) {
            this.errorMessage("Error queuing buffers in method 'preLoadBuffers'");
            this.printStackTrace(var7);
            return false;
        }
        if (this.errorCheck(this.checkALError(), "Error queuing buffers in method 'preLoadBuffers'")) {
            return false;
        }
        AL10.alSourcePlay((int)this.ALSource.get(0));
        return !this.errorCheck(this.checkALError(), "Error playing source in method 'preLoadBuffers'");
    }

    public boolean queueBuffer(byte[] var1) {
        if (this.errorCheck(this.channelType != 1, "Buffers may only be queued for streaming sources.")) {
            return false;
        }
        this.bufferBuffer.clear();
        this.bufferBuffer.put(var1, 0, var1.length);
        this.bufferBuffer.flip();
        IntBuffer var2 = BufferUtils.createIntBuffer((int)1);
        AL10.alSourceUnqueueBuffers((int)this.ALSource.get(0), (IntBuffer)var2);
        if (this.checkALError()) {
            return false;
        }
        AL10.alBufferData((int)var2.get(0), (int)this.ALformat, (ByteBuffer)this.bufferBuffer, (int)this.sampleRate);
        if (this.checkALError()) {
            return false;
        }
        AL10.alSourceQueueBuffers((int)this.ALSource.get(0), (IntBuffer)var2);
        return !this.checkALError();
    }

    public int feedRawAudioData(byte[] var1) {
        IntBuffer var3;
        if (this.errorCheck(this.channelType != 1, "Raw audio data can only be fed to streaming sources.")) {
            return -1;
        }
        ByteBuffer var2 = ByteBuffer.wrap(var1, 0, var1.length);
        int var4 = AL10.alGetSourcei((int)this.ALSource.get(0), (int)4118);
        if (var4 > 0) {
            var3 = BufferUtils.createIntBuffer((int)var4);
            AL10.alGenBuffers((IntBuffer)var3);
            if (this.errorCheck(this.checkALError(), "Error clearing stream buffers in method 'feedRawAudioData'")) {
                return -1;
            }
            AL10.alSourceUnqueueBuffers((int)this.ALSource.get(0), (IntBuffer)var3);
            if (this.errorCheck(this.checkALError(), "Error unqueuing stream buffers in method 'feedRawAudioData'")) {
                return -1;
            }
        } else {
            var3 = BufferUtils.createIntBuffer((int)1);
            AL10.alGenBuffers((IntBuffer)var3);
            if (this.errorCheck(this.checkALError(), "Error generating stream buffers in method 'preLoadBuffers'")) {
                return -1;
            }
        }
        AL10.alBufferData((int)var3.get(0), (int)this.ALformat, (ByteBuffer)var2, (int)this.sampleRate);
        if (this.checkALError()) {
            return -1;
        }
        AL10.alSourceQueueBuffers((int)this.ALSource.get(0), (IntBuffer)var3);
        if (this.checkALError()) {
            return -1;
        }
        if (this.attachedSource != null && this.attachedSource.channel == this && this.attachedSource.active() && !this.playing()) {
            AL10.alSourcePlay((int)this.ALSource.get(0));
            this.checkALError();
        }
        return var4;
    }

    public int buffersProcessed() {
        if (this.channelType != 1) {
            return 0;
        }
        int var1 = AL10.alGetSourcei((int)this.ALSource.get(0), (int)4118);
        return this.checkALError() ? 0 : var1;
    }

    public void flush() {
        if (this.channelType == 1) {
            if (!this.checkALError()) {
                IntBuffer var2 = BufferUtils.createIntBuffer((int)1);
                for (int var1 = AL10.alGetSourcei((int)this.ALSource.get(0), (int)4117); var1 > 0; --var1) {
                    try {
                        AL10.alSourceUnqueueBuffers((int)this.ALSource.get(0), (IntBuffer)var2);
                    }
                    catch (Exception var4) {
                        return;
                    }
                    if (!this.checkALError()) continue;
                    return;
                }
            }
        }
    }

    public void close() {
        try {
            AL10.alSourceStop((int)this.ALSource.get(0));
            AL10.alGetError();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.channelType == 1) {
            this.flush();
        }
    }

    public void play() {
        AL10.alSourcePlay((int)this.ALSource.get(0));
        this.checkALError();
    }

    public void pause() {
        AL10.alSourcePause((int)this.ALSource.get(0));
        this.checkALError();
    }

    public void stop() {
        AL10.alSourceStop((int)this.ALSource.get(0));
        this.checkALError();
    }

    public void rewind() {
        if (this.channelType != 1) {
            AL10.alSourceRewind((int)this.ALSource.get(0));
            this.checkALError();
        }
    }

    public boolean playing() {
        int var1 = AL10.alGetSourcei((int)this.ALSource.get(0), (int)4112);
        if (this.checkALError()) {
            return false;
        }
        return var1 == 4114;
    }

    private boolean checkALError() {
        switch (AL10.alGetError()) {
            case 0: {
                return false;
            }
            case 40961: {
                this.errorMessage("Invalid name parameter.");
                return true;
            }
            case 40962: {
                this.errorMessage("Invalid parameter.");
                return true;
            }
            case 40963: {
                this.errorMessage("Invalid enumerated parameter value.");
                return true;
            }
            case 40964: {
                this.errorMessage("Illegal call.");
                return true;
            }
            case 40965: {
                this.errorMessage("Unable to allocate memory.");
                return true;
            }
        }
        this.errorMessage("An unrecognized error occurred.");
        return true;
    }
}

