/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class FootstepParticle
extends Particle {
    private int life = 0;
    private int lifeTime;
    private final RenderEngine renderEngine;

    public FootstepParticle(RenderEngine renderEngine, World world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.renderEngine = renderEngine;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.lifeTime = 200;
    }

    @Override
    public void render(Tessellator t, float partialTick, float xa, float ya, float za, float xa2, float za2) {
        float a;
        float time = ((float)this.life + partialTick) / (float)this.lifeTime;
        if ((a = 2.0f - (time *= time) * 2.0f) > 1.0f) {
            a = 1.0f;
        }
        a *= 0.2f;
        GL11.glDisable((int)2896);
        float s = 0.125f;
        float x = (float)(this.x - xOff);
        float y = (float)(this.y - yOff);
        float z = (float)(this.z - zOff);
        float br = this.world.getLightBrightness(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z));
        this.renderEngine.bindTexture(this.renderEngine.loadTexture("/assets/minecraft/textures/misc/footprint.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        t.startDrawingQuads();
        t.setColorRGBA_F(br, br, br, a);
        t.addVertexWithUV(x - s, y, z + s, 0.0, 1.0);
        t.addVertexWithUV(x + s, y, z + s, 1.0, 1.0);
        t.addVertexWithUV(x + s, y, z - s, 1.0, 0.0);
        t.addVertexWithUV(x - s, y, z - s, 0.0, 0.0);
        t.draw();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
    }

    @Override
    public void tick() {
        ++this.life;
        if (this.life == this.lifeTime) {
            this.remove();
        }
    }

    @Override
    public int getParticleTexture() {
        return 3;
    }
}

