/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.render.FontRenderer;
import org.lwjgl.opengl.GL11;

public class GuiClickableLabel
extends GuiButton {
    int textColor;
    int bgColor;
    public boolean shadow = true;

    public GuiClickableLabel(int id, int xPosition, int yPosition, String s, int textColor, int bgColor) {
        super(id, xPosition, yPosition, s);
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.height = 12;
        this.width = 0;
    }

    public GuiClickableLabel(int id, int xPosition, int yPosition, String s, int textColor) {
        this(id, xPosition, yPosition, s, textColor, 0x7F000000);
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = mc.fontRenderer;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        this.width = fontrenderer.getStringWidth(this.displayString) + 4;
        this.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, this.enabled ? (hovered ? 2139128000 : this.bgColor) : 0);
        if (this.enabled && (this.shadow || hovered)) {
            fontrenderer.drawStringWithShadow(this.displayString, this.xPosition + 2, this.yPosition + 2, hovered ? 0xFFFFA0 : this.textColor);
        } else {
            fontrenderer.drawString(this.displayString, this.xPosition + 2, this.yPosition + 2, 0x7F7F7F);
        }
        this.mouseDragged(mc, mouseX, mouseY);
    }
}

