/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.net.ConnectException;
import java.net.UnknownHostException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConnectFailed;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectServer;
import net.minecraft.client.net.handler.ClientPacketHandler;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.packet.PreLoginPacket;

public class GuiConnecting
extends GuiScreen {
    private ClientPacketHandler clientHandler;
    private boolean cancelled = false;

    public GuiConnecting(Minecraft minecraft, String hostName, int port) {
        System.out.println("Connecting to " + hostName + ", " + port);
        minecraft.changeWorld(null);
        new Thread(() -> {
            try {
                this.clientHandler = new ClientPacketHandler(this.mc, hostName, port);
                if (this.cancelled) {
                    return;
                }
                this.clientHandler.addToSendQueue(new PreLoginPacket(this.mc.session.username));
            }
            catch (UnknownHostException unknownhostexception) {
                if (this.cancelled) {
                    return;
                }
                this.mc.displayGuiScreen(new GuiConnectFailed("connect.failed", "disconnect.genericReason", new Object[]{"Unknown host '" + hostName + "'"}));
            }
            catch (ConnectException connectexception) {
                if (this.cancelled) {
                    return;
                }
                this.mc.displayGuiScreen(new GuiConnectFailed("connect.failed", "disconnect.genericReason", new Object[]{connectexception.getMessage()}));
            }
            catch (Exception exception) {
                if (this.cancelled) {
                    return;
                }
                exception.printStackTrace();
                this.mc.displayGuiScreen(new GuiConnectFailed("connect.failed", "disconnect.genericReason", new Object[]{exception.toString()}));
            }
        }).start();
    }

    @Override
    public void tick() {
        if (this.clientHandler != null) {
            this.clientHandler.tick();
        }
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
    }

    @Override
    public void init() {
        I18n stringtranslate = I18n.getInstance();
        this.controlList.clear();
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.connecting.button.cancel")));
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (button.id == 0) {
            this.cancelled = true;
            if (this.clientHandler != null) {
                this.clientHandler.disconnect();
            }
            this.mc.displayGuiScreen(new GuiSelectServer(new GuiMainMenu()));
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        this.drawDefaultBackground();
        I18n stringtranslate = I18n.getInstance();
        if (this.clientHandler == null) {
            this.drawStringCentered(this.fontRenderer, stringtranslate.translateKey("gui.connecting.label.connecting"), this.width / 2, this.height / 2 - 50, 0xFFFFFF);
            this.drawStringCentered(this.fontRenderer, "", this.width / 2, this.height / 2 - 10, 0xFFFFFF);
        } else {
            this.drawStringCentered(this.fontRenderer, stringtranslate.translateKey("gui.connecting.label.logging_in"), this.width / 2, this.height / 2 - 50, 0xFFFFFF);
            this.drawStringCentered(this.fontRenderer, this.clientHandler.message, this.width / 2, this.height / 2 - 10, 0xFFFFFF);
        }
        super.drawScreen(mouseX, mouseY, partialTick);
    }
}

