/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.BreakingItemParticle;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiTextCycle;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class ItemFXEntry
extends ParticleEntry {
    protected int itemID;

    @Override
    public String getParticleName(I18n translator) {
        return "item";
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen) {
        final GuiTextCycle<Integer> itemIdCycle = new GuiTextCycle<Integer>(parentScreen, mc.fontRenderer, -120, 0, 120, 20, Integer.valueOf(this.itemID)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ItemFXEntry.this.cycleItemId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, Item.itemsList.length);
                }
                catch (Exception exception) {
                    return ItemFXEntry.this.itemID;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        itemIdCycle.textField.setPrefaceText("ID: ");
        itemIdCycle.textField.setPlaceholder("Item ID");
        itemIdCycle.setOnValueChanged(() -> {
            this.itemID = (Integer)itemIdCycle.getCurrentElement();
        });
        return new ArrayList<GuiButton>(){
            {
                this.add(itemIdCycle);
            }
        };
    }

    @Override
    public void spawnParticle(Minecraft mc, World world, double x, double y, double z) {
        mc.effectRenderer.addEffect(new BreakingItemParticle(world, x, y, z, Item.itemsList[this.itemID]));
    }

    @Override
    public void onOpen() {
        this.itemID = 16384;
    }

    @Override
    public void onClose() {
    }

    private int cycleItemId(int itemId, int offset) {
        int numItems = Item.itemsList.length - Block.blocksList.length;
        int _itemId = MathHelper.clamp(itemId - numItems, 0, numItems);
        int id = (_itemId + numItems + offset) % numItems;
        while (Item.itemsList[id + Block.blocksList.length] == null) {
            id = (id + (int)Math.signum(offset) + numItems) % numItems;
        }
        return id + Block.blocksList.length;
    }
}

