/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerButton;
import org.lwjgl.input.Keyboard;

public abstract class GuiListSelectorButton<T>
extends GuiListenerButton {
    public final List<T> list;
    private int index;
    private final String formattedText;
    private final T defaultElement;

    public GuiListSelectorButton(int id, int xPosition, int yPosition, int width, int height, String formattedText, Collection<T> collection, T initialElement) {
        super(id, xPosition, yPosition, width, height, "");
        this.displayString = String.format(formattedText, this.getNameFromElement(initialElement));
        this.defaultElement = initialElement;
        this.formattedText = formattedText;
        this.list = new ArrayList<T>(collection);
        this.index = this.list.indexOf(initialElement);
    }

    @Override
    public void onClick(Minecraft mc, int mouseX, int mouseY) {
        if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL)) {
            this.resetValue();
        } else {
            this.offsetId(Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) ? -1 : 1);
        }
        this.displayString = String.format(this.formattedText, this.getNameFromElement(this.getCurrentElement()));
        super.onClick(mc, mouseX, mouseY);
    }

    public T getCurrentElement() {
        return this.list.get(this.index);
    }

    private void offsetId(int offset) {
        int _index = this.index;
        this.index = (this.index + this.list.size() + offset) % this.list.size();
        if (_index != this.index) {
            this.onValueChanged();
        }
    }

    public void resetValue() {
        this.index = this.list.indexOf(this.defaultElement);
    }

    public abstract String getNameFromElement(T var1);
}

