/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.toasts;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToastable;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AchievementToast
implements IToastable {
    private static final double ANIMATION_DURATION_MILLIS = 3000.0;
    private long startTime;
    private final Minecraft mc = Minecraft.getMinecraft(this);
    private final Achievement achievement;
    private final boolean informational;

    public AchievementToast(Achievement achievement, boolean informational) {
        this.achievement = achievement;
        this.informational = informational;
    }

    @Override
    public boolean messageOnly(long runtime) {
        return this.informational;
    }

    @Override
    public String getTitle(long runtime) {
        return I18n.getInstance().translateKey("gui.achievement.label.get");
    }

    @Override
    public int nameColor(long runtime) {
        return -256;
    }

    @Override
    public String getMessage(long runtime) {
        return this.informational ? this.achievement.getDescription() : this.achievement.getStatName();
    }

    @Override
    public int descriptionColor(long runtime) {
        return -1;
    }

    @Override
    public double getAnimationProgress(long runtime) {
        runtime = System.currentTimeMillis() - this.startTime;
        double progress = (double)runtime / 3000.0;
        if (this.informational && !this.mc.statsCounter.isUnlocked(this.achievement)) {
            progress = Math.min(progress, 0.5);
            this.startTime = (long)((double)System.currentTimeMillis() - 1500.0);
        }
        return progress;
    }

    @Override
    public String getTexture(long runtime) {
        return "minecraft:gui/toast";
    }

    @Override
    public void onToastStart() {
        Random r = new Random();
        this.startTime = System.currentTimeMillis();
        if (!this.informational) {
            this.mc.sndManager.playSound("random.achievement", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
    }

    @Override
    public void onToastEnd() {
        Random r = new Random();
    }

    @Override
    public boolean isEquivalentToast(@NotNull IToastable toast) {
        if (toast instanceof AchievementToast) {
            AchievementToast achievementToast = (AchievementToast)toast;
            return this.achievement == achievementToast.achievement && this.informational == ((AchievementToast)toast).informational;
        }
        return false;
    }

    @Override
    @Nullable
    public ItemStack getIcon(long runtime) {
        return Item.getItem(this.achievement.iconItemId).getDefaultStack();
    }
}

