/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.ToggleableOption;

public class RangeOption
extends ToggleableOption<Integer> {
    public final int highest;
    public final int lowest;

    public RangeOption(GameSettings gameSettings, String name, int defaultValue, int values) {
        super(gameSettings, name, defaultValue, RangeOption.getValueArray(values));
        this.highest = ((Integer[])this.values)[((Integer[])this.values).length - 1];
        this.lowest = ((Integer[])this.values)[0];
    }

    public RangeOption(GameSettings gameSettings, String name, int defaultValue, int lowest, int highest) {
        super(gameSettings, name, defaultValue, RangeOption.getValueArray(lowest, highest));
        this.highest = ((Integer[])this.values)[((Integer[])this.values).length - 1];
        this.lowest = ((Integer[])this.values)[0];
    }

    @Override
    public void parse(String string) {
        this.value = Integer.parseInt(string);
    }

    public static Integer[] getValueArray(int size) {
        Integer[] array = new Integer[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static Integer[] getValueArray(int lowest, int highest) {
        Integer[] array = new Integer[highest - lowest + 1];
        for (int i = 0; i < array.length; ++i) {
            array[i] = i + lowest;
        }
        return array;
    }

    @Override
    public boolean isSlider() {
        return true;
    }
}

