/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.entity.particle.TerrainParticle;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class EffectRenderer {
    protected World worldObj;
    private List[] fxLayers = new List[4];
    private RenderEngine renderer;
    private Random rand = new Random();

    public EffectRenderer(World world, RenderEngine renderengine) {
        if (world != null) {
            this.worldObj = world;
        }
        this.renderer = renderengine;
        for (int i = 0; i < 4; ++i) {
            this.fxLayers[i] = new ArrayList();
        }
    }

    public void addEffect(Particle entityfx) {
        int i = entityfx.getParticleTexture();
        if (this.fxLayers[i].size() >= 4000) {
            this.fxLayers[i].remove(0);
        }
        this.fxLayers[i].add(entityfx);
    }

    public void updateEffects() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < this.fxLayers[i].size(); ++j) {
                Particle entityfx = (Particle)this.fxLayers[i].get(j);
                entityfx.tick();
                if (!entityfx.removed) continue;
                this.fxLayers[i].remove(j--);
            }
        }
    }

    public void renderParticles(ICamera camera, float partialTick) {
        double pitch = camera.getXRot(partialTick);
        double yaw = camera.getYRot(partialTick);
        float rotationX = MathHelper.cos((float)(yaw * Math.PI) / 180.0f);
        float rotationZ = MathHelper.sin((float)(yaw * Math.PI) / 180.0f);
        float rotationYZ = -rotationZ * MathHelper.sin((float)(pitch * Math.PI / 180.0));
        float rotationXY = rotationX * MathHelper.sin((float)(pitch * Math.PI / 180.0));
        float rotationXZ = MathHelper.cos((float)(pitch * Math.PI / 180.0));
        Particle.xOff = camera.getX(partialTick);
        Particle.yOff = camera.getY(partialTick);
        Particle.zOff = camera.getZ(partialTick);
        for (int i = 0; i < 3; ++i) {
            if (this.fxLayers[i].size() == 0) continue;
            int texture = 0;
            if (i == 0) {
                texture = TextureRegistry.particleAtlas.id();
            }
            if (i == 1) {
                texture = TextureRegistry.blockAtlas.id();
            }
            if (i == 2) {
                texture = TextureRegistry.itemAtlas.id();
            }
            GL11.glBindTexture((int)3553, (int)texture);
            Tessellator tessellator = Tessellator.instance;
            tessellator.startDrawingQuads();
            for (int k = 0; k < this.fxLayers[i].size(); ++k) {
                Particle entityfx = (Particle)this.fxLayers[i].get(k);
                entityfx.render(tessellator, partialTick, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
            }
            tessellator.draw();
        }
    }

    public void renderParticlesAtOrigin(float partialTick) {
        int layerId = 3;
        if (this.fxLayers[layerId].size() == 0) {
            return;
        }
        Tessellator tessellator = Tessellator.instance;
        for (int i = 0; i < this.fxLayers[layerId].size(); ++i) {
            Particle entityfx = (Particle)this.fxLayers[layerId].get(i);
            entityfx.render(tessellator, partialTick, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public void clearEffects(World world) {
        this.worldObj = world;
        for (int i = 0; i < 4; ++i) {
            this.fxLayers[i].clear();
        }
    }

    public void addBlockDestroyEffects(int x, int y, int z, int blockId, int i1) {
        Block block = Block.blocksList[blockId];
        if (block == null) {
            return;
        }
        int amount = 4;
        if (block == Blocks.FIRE) {
            return;
        }
        for (int _x = 0; _x < amount; ++_x) {
            for (int _y = 0; _y < amount; ++_y) {
                for (int _z = 0; _z < amount; ++_z) {
                    double pX = (double)x + ((double)_x + 0.5) / (double)amount;
                    double pY = (double)y + ((double)_y + 0.5) / (double)amount;
                    double pZ = (double)z + ((double)_z + 0.5) / (double)amount;
                    int side = this.rand.nextInt(6);
                    this.addEffect(new TerrainParticle(this.worldObj, pX, pY, pZ, pX - (double)x - 0.5, pY - (double)y - 0.5, pZ - (double)z - 0.5, block, side, i1).init(x, y, z));
                }
            }
        }
    }

    public void addBlockHitEffects(int i, int j, int k, Side side) {
        int l = side.getId();
        int i1 = this.worldObj.getBlockId(i, j, k);
        if (i1 == 0) {
            return;
        }
        Block block = Block.blocksList[i1];
        float f = 0.1f;
        double d = (double)i + this.rand.nextDouble() * (block.maxX - block.minX - (double)(f * 2.0f)) + (double)f + block.minX;
        double d1 = (double)j + this.rand.nextDouble() * (block.maxY - block.minY - (double)(f * 2.0f)) + (double)f + block.minY;
        double d2 = (double)k + this.rand.nextDouble() * (block.maxZ - block.minZ - (double)(f * 2.0f)) + (double)f + block.minZ;
        if (l == 0) {
            d1 = (double)j + block.minY - (double)f;
        }
        if (l == 1) {
            d1 = (double)j + block.maxY + (double)f;
        }
        if (l == 2) {
            d2 = (double)k + block.minZ - (double)f;
        }
        if (l == 3) {
            d2 = (double)k + block.maxZ + (double)f;
        }
        if (l == 4) {
            d = (double)i + block.minX - (double)f;
        }
        if (l == 5) {
            d = (double)i + block.maxX + (double)f;
        }
        this.addEffect(new TerrainParticle(this.worldObj, d, d1, d2, 0.0, 0.0, 0.0, block, l, this.worldObj.getBlockMetadata(i, j, k)).init(i, j, k).setPower(0.2f).setScale(0.6f));
    }

    public String getNumParticlesString() {
        return "" + (this.fxLayers[0].size() + this.fxLayers[1].size() + this.fxLayers[2].size());
    }
}

