/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.core.Global;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class OpenGLHelper {
    private static Set<String> errors = new HashSet<String>();
    public static boolean enableOcclusionCheck = false;
    public static boolean enableSphericalFog = false;
    public static boolean gl20 = false;
    public static boolean gl31 = false;

    public static void testCapabilities(Minecraft minecraft) {
        System.out.println(GL11.glGetString((int)7938));
        System.out.println(GL11.glGetString((int)7936));
        System.out.println(GL11.glGetString((int)7937));
        ContextCapabilities capabilities = GLContext.getCapabilities();
        System.out.println("GL_ARB_framebuffer_object: " + capabilities.GL_ARB_framebuffer_object);
        System.out.println("GL_ARB_occlusion_query: " + capabilities.GL_ARB_occlusion_query);
        System.out.println("GL_NV_fog_distance: " + capabilities.GL_NV_fog_distance);
        enableOcclusionCheck = capabilities.GL_ARB_occlusion_query;
        enableSphericalFog = capabilities.GL_NV_fog_distance;
        gl20 = capabilities.OpenGL20;
        gl31 = capabilities.OpenGL31;
        if (((Boolean)minecraft.gameSettings.disableShaders.value).booleanValue()) {
            Shaders.enableShaders = false;
            System.out.println("Shaders disabled in options file!");
            return;
        }
        Shaders.enableShaders = capabilities.GL_ARB_framebuffer_object && capabilities.OpenGL20;
        System.out.println("Enable Shaders: " + Shaders.enableShaders);
    }

    public static void checkError(String info) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                String error = errorCode + " (" + OpenGLHelper.getErrorDescription(errorCode) + "): " + info;
                throw new RuntimeException("OpenGL Error " + error);
            }
            if (!errors.contains(info)) {
                errors.add(info);
                String error = errorCode + " (" + OpenGLHelper.getErrorDescription(errorCode) + "): " + info;
                System.out.println("########## GL ERROR ##########");
                System.out.println("OpenGL Error " + error);
            }
        }
    }

    public static String getErrorDescription(int error) {
        if (error == 1280) {
            return "Invalid Enum";
        }
        if (error == 1281) {
            return "Invalid Value";
        }
        if (error == 1282) {
            return "Invalid Operation";
        }
        if (error == 1286) {
            return "Invalid Framebuffer Operation";
        }
        if (error == 1285) {
            return "Out of Memory";
        }
        if (error == 1284) {
            return "Stack Underflow";
        }
        if (error == 1283) {
            return "Stack Overflow";
        }
        return "Unknown Error";
    }

    public static void glColor1i(int rgb) {
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        GL11.glColor3f((float)r, (float)g, (float)b);
    }
}

