/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.LeavesBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class CacaoLeavesBlockModel<T extends Block>
extends LeavesBlockModel<T> {
    protected IconCoordinate[] growthStages = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/leaves_cacao_bean_stage0"), TextureRegistry.getTexture("minecraft:block/leaves_cacao_bean_stage1"), TextureRegistry.getTexture("minecraft:block/leaves_cacao_bean_stage2"), TextureRegistry.getTexture("minecraft:block/leaves_cacao_bean_stage3")};

    public CacaoLeavesBlockModel(Block block) {
        super(block, "minecraft:block/leaves_cacao");
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        super.render(tessellator, x, y, z);
        int growthRate = (CacaoLeavesBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z) & 0xF0) >> 4;
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            int lmc = this.block.getLightmapCoord(CacaoLeavesBlockModel.renderBlocks.blockAccess, x, y, z);
            if (Block.lightEmission[this.block.id] > 0) {
                lmc = LightmapHelper.setBlocklightValue(lmc, 15);
            }
            tessellator.setLightmapCoord(lmc);
        } else {
            brightness = this.getBlockBrightness(CacaoLeavesBlockModel.renderBlocks.blockAccess, x, y, z);
            if (Block.lightEmission[this.block.id] > 0) {
                brightness = 1.0f;
            }
        }
        float cNorthSouth = 0.8f;
        float cEastWest = 0.6f;
        if (growthRate > 0) {
            CacaoLeavesBlockModel.renderBlocks.overrideBlockTexture = this.growthStages[Math.min(growthRate - 1, 3)];
            tessellator.setColorOpaque_F(0.8f * brightness, 0.8f * brightness, 0.8f * brightness);
            this.renderNorthFace(tessellator, this.block, x, y, z, CacaoLeavesBlockModel.renderBlocks.overrideBlockTexture);
            this.renderSouthFace(tessellator, this.block, x, y, z, CacaoLeavesBlockModel.renderBlocks.overrideBlockTexture);
            tessellator.setColorOpaque_F(0.6f * brightness, 0.6f * brightness, 0.6f * brightness);
            this.renderEastFace(tessellator, this.block, x, y, z, CacaoLeavesBlockModel.renderBlocks.overrideBlockTexture);
            this.renderWestFace(tessellator, this.block, x, y, z, CacaoLeavesBlockModel.renderBlocks.overrideBlockTexture);
            CacaoLeavesBlockModel.renderBlocks.overrideBlockTexture = null;
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderBlockOnInventory(tessellator, metadata, brightness, alpha, lightmapCoordinate);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        IconCoordinate cacaoCoord = this.growthStages[3];
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

