/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class GrassBlockModel<T extends Block>
extends StandardBlockModel<T> {
    public static boolean useOverlay = false;
    private static final IconCoordinate[] overlayIndices = new IconCoordinate[]{null, null, TextureRegistry.getTexture("minecraft:block/grass_side_overlay"), TextureRegistry.getTexture("minecraft:block/grass_side_overlay"), TextureRegistry.getTexture("minecraft:block/grass_side_overlay"), TextureRegistry.getTexture("minecraft:block/grass_side_overlay")};
    protected IconCoordinate snowSide = TextureRegistry.getTexture("minecraft:block/grass_snowy_side");

    public GrassBlockModel(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        boolean didRender = this.renderStandardBlock(tessellator, this.block, x, y, z);
        if (RenderBlocks.fancyGrass) {
            useOverlay = true;
            didRender |= this.renderStandardBlock(tessellator, this.block, x, y, z);
            useOverlay = false;
        }
        return didRender;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        float yOffset = 0.5f;
        this.setBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)(0.0f - yOffset), (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.draw();
        if (GrassBlockModel.renderBlocks.useInventoryTint) {
            int l = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            float f4 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f8 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f9 = (float)(l & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f4 * brightness), (float)(f8 * brightness), (float)(f9 * brightness), (float)alpha);
        }
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        tessellator.draw();
        if (RenderBlocks.fancyGrass) {
            useOverlay = true;
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
            tessellator.draw();
            useOverlay = false;
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        Material material = blockAccess.getBlockMaterial(x, y + 1, z);
        if ((material == Material.topSnow || material == Material.snow) && side.getAxis() != Axis.Y) {
            return this.snowSide;
        }
        return super.getBlockTexture(blockAccess, x, y, z, side);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (useOverlay) {
            return overlayIndices[side.getId()];
        }
        return this.atlasIndices[side.getId()];
    }

    @Override
    public boolean shouldSideBeColored(WorldSource blockAccess, int x, int y, int z, int side, int meta) {
        Material material = blockAccess.getBlockMaterial(x, y + 1, z);
        if (material == Material.topSnow || material == Material.snow) {
            return false;
        }
        return useOverlay || side == Side.TOP.getId();
    }
}

