/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;

public class TorchBlockModel<T extends Block>
extends StandardBlockModel<T> {
    public TorchBlockModel(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(TorchBlockModel.renderBlocks.blockAccess, x, y, z);
        int l = TorchBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(TorchBlockModel.renderBlocks.blockAccess, x, y, z));
        } else {
            brightness = this.getBlockBrightness(TorchBlockModel.renderBlocks.blockAccess, x, y, z);
            if (Block.lightEmission[this.block.id] > 0) {
                brightness = 1.0f;
            }
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        double d = 0.4;
        double d1 = 0.5 - d;
        double d2 = 0.2;
        if (l == 1) {
            this.renderTorchAtAngle(tessellator, (double)x - d1, (double)y + d2, z, -d, 0.0);
        } else if (l == 2) {
            this.renderTorchAtAngle(tessellator, (double)x + d1, (double)y + d2, z, d, 0.0);
        } else if (l == 3) {
            this.renderTorchAtAngle(tessellator, x, (double)y + d2, (double)z - d1, 0.0, -d);
        } else if (l == 4) {
            this.renderTorchAtAngle(tessellator, x, (double)y + d2, (double)z + d1, 0.0, d);
        } else {
            this.renderTorchAtAngle(tessellator, x, y, z, 0.0, 0.0);
        }
        return true;
    }

    public void renderTorchAtAngle(Tessellator tessellator, double x, double y, double z, double topOffsetX, double topOffsetZ) {
        IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0);
        if (TorchBlockModel.renderBlocks.overrideBlockTexture != null) {
            texture = TorchBlockModel.renderBlocks.overrideBlockTexture;
        }
        double minU = texture.getIconUMin();
        double maxU = texture.getIconUMax();
        double minV = texture.getIconVMin();
        double maxV = texture.getIconVMax();
        double topMinU = texture.getSubIconU(0.4375);
        double topMinV = texture.getSubIconV(0.375);
        double topMaxU = texture.getSubIconU(0.5625);
        double topMaxV = texture.getSubIconV(0.5);
        double bottomMinU = texture.getSubIconU(0.4375);
        double bottomMinV = texture.getSubIconV(0.875);
        double bottomMaxU = texture.getSubIconU(0.5625);
        double bottomMaxV = maxV;
        double d9 = (x += 0.5) - 0.5;
        double d10 = x + 0.5;
        double d11 = (z += 0.5) - 0.5;
        double d12 = z + 0.5;
        double d13 = 0.0625;
        double d14 = 0.625;
        tessellator.addVertexWithUV(x - d13 + topOffsetX, y + 0.0, z + d13 + topOffsetZ, bottomMinU, bottomMaxV);
        tessellator.addVertexWithUV(x - d13 + topOffsetX, y + 0.0, z - d13 + topOffsetZ, bottomMinU, bottomMinV);
        tessellator.addVertexWithUV(x + topOffsetX + d13, y + 0.0, z - d13 + topOffsetZ, bottomMaxU, bottomMinV);
        tessellator.addVertexWithUV(x + topOffsetX + d13, y + 0.0, z + d13 + topOffsetZ, bottomMaxU, bottomMaxV);
        tessellator.addVertexWithUV(x + topOffsetX * (1.0 - d14) - d13, y + d14, z + topOffsetZ * (1.0 - d14) - d13, topMinU, topMinV);
        tessellator.addVertexWithUV(x + topOffsetX * (1.0 - d14) - d13, y + d14, z + topOffsetZ * (1.0 - d14) + d13, topMinU, topMaxV);
        tessellator.addVertexWithUV(x + topOffsetX * (1.0 - d14) + d13, y + d14, z + topOffsetZ * (1.0 - d14) + d13, topMaxU, topMaxV);
        tessellator.addVertexWithUV(x + topOffsetX * (1.0 - d14) + d13, y + d14, z + topOffsetZ * (1.0 - d14) - d13, topMaxU, topMinV);
        tessellator.addVertexWithUV(x - d13, y + 1.0, d11, minU, minV);
        tessellator.addVertexWithUV(x - d13 + topOffsetX, y + 0.0, d11 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(x - d13 + topOffsetX, y + 0.0, d12 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(x - d13, y + 1.0, d12, maxU, minV);
        tessellator.addVertexWithUV(x + d13, y + 1.0, d12, minU, minV);
        tessellator.addVertexWithUV(x + topOffsetX + d13, y + 0.0, d12 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(x + topOffsetX + d13, y + 0.0, d11 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(x + d13, y + 1.0, d11, maxU, minV);
        tessellator.addVertexWithUV(d9, y + 1.0, z + d13, minU, minV);
        tessellator.addVertexWithUV(d9 + topOffsetX, y + 0.0, z + d13 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(d10 + topOffsetX, y + 0.0, z + d13 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(d10, y + 1.0, z + d13, maxU, minV);
        tessellator.addVertexWithUV(d10, y + 1.0, z - d13, minU, minV);
        tessellator.addVertexWithUV(d10 + topOffsetX, y + 0.0, z - d13 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(d9 + topOffsetX, y + 0.0, z - d13 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(d9, y + 1.0, z - d13, maxU, minV);
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public float getItemRenderScale() {
        return 0.5f;
    }
}

