/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.projectile.ArrowProjectile;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class ArrowRenderer
extends EntityRenderer<ArrowProjectile> {
    @Override
    public void render(Tessellator tessellator, ArrowProjectile arrow, double x, double y, double z, float yaw, float partialTick) {
        this.bindTexture("/assets/minecraft/textures/entity/arrows.png");
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(arrow.yRotO + (arrow.yRot - arrow.yRotO) * partialTick - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(arrow.xRotO + (arrow.xRot - arrow.xRotO) * partialTick), (float)0.0f, (float)0.0f, (float)1.0f);
        int arrowType = arrow.getArrowType();
        float bodyMinU = 0.0f;
        float bodyMaxU = 0.5f;
        float bodyMinV = (float)(arrowType * 10) / 32.0f;
        float bodyMaxV = (float)(5 + arrowType * 10) / 32.0f;
        float tailMinU = 0.0f;
        float tailMaxU = 0.15625f;
        float tailMinV = (float)(5 + arrowType * 10) / 32.0f;
        float tailMaxV = (float)(10 + arrowType * 10) / 32.0f;
        float scale = 0.05625f;
        GL11.glEnable((int)32826);
        float shakeAmount = (float)arrow.shake - partialTick;
        if (shakeAmount > 0.0f) {
            float shakeAngle = -MathHelper.sin(shakeAmount * 3.0f) * shakeAmount;
            GL11.glRotatef((float)shakeAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)-4.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3f((float)scale, (float)0.0f, (float)0.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-7.0, -2.0, -2.0, tailMinU, tailMinV);
        tessellator.addVertexWithUV(-7.0, -2.0, 2.0, tailMaxU, tailMinV);
        tessellator.addVertexWithUV(-7.0, 2.0, 2.0, tailMaxU, tailMaxV);
        tessellator.addVertexWithUV(-7.0, 2.0, -2.0, tailMinU, tailMaxV);
        tessellator.draw();
        GL11.glNormal3f((float)(-scale), (float)0.0f, (float)0.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-7.0, 2.0, -2.0, tailMinU, tailMinV);
        tessellator.addVertexWithUV(-7.0, 2.0, 2.0, tailMaxU, tailMinV);
        tessellator.addVertexWithUV(-7.0, -2.0, 2.0, tailMaxU, tailMaxV);
        tessellator.addVertexWithUV(-7.0, -2.0, -2.0, tailMinU, tailMaxV);
        tessellator.draw();
        for (int i = 0; i < 4; ++i) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)scale);
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-8.0, -2.0, 0.0, bodyMinU, bodyMinV);
            tessellator.addVertexWithUV(8.0, -2.0, 0.0, bodyMaxU, bodyMinV);
            tessellator.addVertexWithUV(8.0, 2.0, 0.0, bodyMaxU, bodyMaxV);
            tessellator.addVertexWithUV(-8.0, 2.0, 0.0, bodyMinU, bodyMaxV);
            tessellator.draw();
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

