/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.render.item.model.StandardItemModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyeItemModel
extends StandardItemModel {
    public static IconCoordinate[] dyeIcons = new IconCoordinate[16];

    public DyeItemModel(Item item) {
        super(item, null);
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(@Nullable Entity entity, ItemStack itemStack) {
        int meta = itemStack.getMetadata();
        return dyeIcons[meta & 0xF];
    }

    static {
        for (DyeColor c : DyeColor.itemOrderedColors()) {
            DyeItemModel.dyeIcons[c.itemMeta] = TextureRegistry.getTexture("minecraft:item/dye_" + c.colorID);
        }
    }
}

