/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.BaseModel;
import net.minecraft.client.render.model.Cube;
import net.minecraft.core.util.helper.MathHelper;

public class BipedModel
extends BaseModel {
    public Cube head;
    public Cube hair;
    public Cube body;
    public Cube arm0;
    public Cube arm1;
    public Cube leg0;
    public Cube leg1;
    public Cube ear;
    public Cube cloak = new Cube(0, 0);
    public boolean holdingLeftHand = false;
    public boolean holdingRightHand = false;
    public boolean sneaking = false;

    public BipedModel() {
        this(0.0f);
    }

    public BipedModel(float expansion) {
        this(expansion, 0.0f);
    }

    public BipedModel(float expansion, float yRotOffset) {
        this.cloak.addBox(-5.0f, 0.0f, -1.0f, 10, 16, 1, expansion);
        this.ear = new Cube(24, 0);
        this.ear.addBox(-3.0f, -6.0f, -1.0f, 6, 6, 1, expansion);
        this.head = new Cube(0, 0);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, expansion);
        this.head.setRotationPoint(0.0f, 0.0f + yRotOffset, 0.0f);
        this.hair = new Cube(32, 0);
        this.hair.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, expansion + 0.5f);
        this.hair.setRotationPoint(0.0f, 0.0f + yRotOffset, 0.0f);
        this.body = new Cube(16, 16);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, expansion);
        this.body.setRotationPoint(0.0f, 0.0f + yRotOffset, 0.0f);
        this.arm0 = new Cube(40, 16);
        this.arm0.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, expansion);
        this.arm0.setRotationPoint(-5.0f, 2.0f + yRotOffset, 0.0f);
        this.arm1 = new Cube(40, 16);
        this.arm1.mirror = true;
        this.arm1.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, expansion);
        this.arm1.setRotationPoint(5.0f, 2.0f + yRotOffset, 0.0f);
        this.leg0 = new Cube(0, 16);
        this.leg0.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion);
        this.leg0.setRotationPoint(-2.0f, 12.0f + yRotOffset, 0.0f);
        this.leg1 = new Cube(0, 16);
        this.leg1.mirror = true;
        this.leg1.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion);
        this.leg1.setRotationPoint(2.0f, 12.0f + yRotOffset, 0.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.head.render(scale);
        this.body.render(scale);
        this.arm0.render(scale);
        this.arm1.render(scale);
        this.leg0.render(scale);
        this.leg1.render(scale);
        this.hair.render(scale);
    }

    @Override
    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.head.yRot = headYaw / 57.29578f;
        this.head.xRot = headPitch / 57.29578f;
        this.hair.yRot = this.head.yRot;
        this.hair.xRot = this.head.xRot;
        this.arm0.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 2.0f * limbYaw * 0.5f;
        this.arm1.xRot = MathHelper.cos(limbSwing * 0.6662f) * 2.0f * limbYaw * 0.5f;
        this.arm0.zRot = 0.0f;
        this.arm1.zRot = 0.0f;
        this.leg0.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        this.leg1.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        this.leg0.yRot = 0.0f;
        this.leg1.yRot = 0.0f;
        if (this.isRiding) {
            this.arm0.xRot += -0.6283185f;
            this.arm1.xRot += -0.6283185f;
            this.leg0.xRot = -1.256637f;
            this.leg1.xRot = -1.256637f;
            this.leg0.yRot = 0.3141593f;
            this.leg1.yRot = -0.3141593f;
        }
        if (this.holdingLeftHand) {
            this.arm1.xRot = this.arm1.xRot * 0.5f - 0.3141593f;
        }
        if (this.holdingRightHand) {
            this.arm0.xRot = this.arm0.xRot * 0.5f - 0.3141593f;
        }
        this.arm0.yRot = 0.0f;
        this.arm1.yRot = 0.0f;
        if (this.onGround > -9990.0f) {
            float f6 = this.onGround;
            this.body.yRot = MathHelper.sin(MathHelper.sqrt_float(f6) * (float)Math.PI * 2.0f) * 0.2f;
            this.arm0.z = MathHelper.sin(this.body.yRot) * 5.0f;
            this.arm0.x = -MathHelper.cos(this.body.yRot) * 5.0f;
            this.arm1.z = -MathHelper.sin(this.body.yRot) * 5.0f;
            this.arm1.x = MathHelper.cos(this.body.yRot) * 5.0f;
            this.arm0.yRot += this.body.yRot;
            this.arm1.yRot += this.body.yRot;
            this.arm1.xRot += this.body.yRot;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            float f7 = MathHelper.sin(f6 * (float)Math.PI);
            float f8 = MathHelper.sin(this.onGround * (float)Math.PI) * -(this.head.xRot - 0.7f) * 0.75f;
            this.arm0.xRot = (float)((double)this.arm0.xRot - ((double)f7 * 1.2 + (double)f8));
            this.arm0.yRot += this.body.yRot * 2.0f;
            this.arm0.zRot = MathHelper.sin(this.onGround * (float)Math.PI) * -0.4f;
        }
        if (this.sneaking) {
            this.body.xRot = 0.5f;
            this.leg0.xRot -= 0.0f;
            this.leg1.xRot -= 0.0f;
            this.arm0.xRot += 0.4f;
            this.arm1.xRot += 0.4f;
            this.leg0.z = 4.0f;
            this.leg1.z = 4.0f;
            this.leg0.y = 9.0f;
            this.leg1.y = 9.0f;
            this.head.y = 1.0f;
            this.hair.y = 1.0f;
        } else {
            this.body.xRot = 0.0f;
            this.leg0.z = 0.0f;
            this.leg1.z = 0.0f;
            this.leg0.y = 12.0f;
            this.leg1.y = 12.0f;
            this.head.y = 0.0f;
            this.hair.y = 0.0f;
        }
        this.arm0.zRot += MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f;
        this.arm1.zRot -= MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f;
        this.arm0.xRot += MathHelper.sin(limbPitch * 0.067f) * 0.05f;
        this.arm1.xRot -= MathHelper.sin(limbPitch * 0.067f) * 0.05f;
    }

    public void renderCloak(float scale) {
        this.cloak.render(scale);
    }
}

