/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import java.util.Random;
import net.minecraft.client.render.model.BaseModel;
import net.minecraft.client.render.model.Cube;
import net.minecraft.core.util.helper.MathHelper;

public class GhastModel
extends BaseModel {
    Cube body;
    Cube[] tentacles = new Cube[9];

    public GhastModel() {
        int yOff = -16;
        this.body = new Cube(0, 0);
        this.body.addBox(-8.0f, -8.0f, -8.0f, 16, 16, 16);
        this.body.y += (float)(24 + yOff);
        Random random = new Random(1660L);
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i] = new Cube(0, 0);
            float xo = (((float)(i % 3) - (float)(i / 3 % 2) * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
            float yo = ((float)(i / 3) / 2.0f * 2.0f - 1.0f) * 5.0f;
            int len = random.nextInt(7) + 8;
            this.tentacles[i].addBox(-1.0f, 0.0f, -1.0f, 2, len, 2);
            this.tentacles[i].x = xo;
            this.tentacles[i].z = yo;
            this.tentacles[i].y = 31 + yOff;
        }
    }

    @Override
    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].xRot = 0.2f * MathHelper.sin(limbPitch * 0.3f + (float)i) + 0.4f;
        }
    }

    @Override
    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.body.render(scale);
        for (Cube tentacle : this.tentacles) {
            tentacle.render(scale);
        }
    }
}

