/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.model.BaseModel;
import net.minecraft.client.render.model.Cube;
import net.minecraft.core.Global;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.WolfMob;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class WolfModel
extends BaseModel {
    public Cube wolfHeadMain;
    public Cube wolfBody;
    public Cube wolfLeg1;
    public Cube wolfLeg2;
    public Cube wolfLeg3;
    public Cube wolfLeg4;
    Cube wolfRightEar;
    Cube wolfLeftEar;
    Cube wolfSnout;
    Cube wolfTail;
    Cube wolfMane;

    public WolfModel(float expandAmount) {
        float f1 = 13.5f;
        this.wolfHeadMain = new Cube(0, 0);
        this.wolfHeadMain.addBox(-3.0f, -3.0f, -2.0f, 6, 6, 4, expandAmount);
        this.wolfHeadMain.setRotationPoint(-1.0f, f1, -7.0f);
        this.wolfBody = new Cube(18, 14);
        this.wolfBody.addBox(-4.0f, -2.0f, -3.0f, 6, 9, 6, expandAmount);
        this.wolfBody.setRotationPoint(0.0f, 14.0f, 2.0f);
        this.wolfMane = new Cube(21, 0);
        this.wolfMane.addBox(-4.0f, -3.0f, -3.0f, 8, 6, 7, expandAmount);
        this.wolfMane.setRotationPoint(-1.0f, 14.0f, 2.0f);
        this.wolfLeg1 = new Cube(0, 18);
        this.wolfLeg1.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfLeg1.setRotationPoint(-2.5f, 16.0f, 7.0f);
        this.wolfLeg2 = new Cube(0, 18);
        this.wolfLeg2.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfLeg2.setRotationPoint(0.5f, 16.0f, 7.0f);
        this.wolfLeg3 = new Cube(0, 18);
        this.wolfLeg3.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfLeg3.setRotationPoint(-2.5f, 16.0f, -4.0f);
        this.wolfLeg4 = new Cube(0, 18);
        this.wolfLeg4.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfLeg4.setRotationPoint(0.5f, 16.0f, -4.0f);
        this.wolfTail = new Cube(9, 18);
        this.wolfTail.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfTail.setRotationPoint(-1.0f, 12.0f, 8.0f);
        this.wolfRightEar = new Cube(16, 14);
        this.wolfRightEar.addBox(-3.0f, -5.0f, 0.0f, 2, 2, 1, expandAmount);
        this.wolfRightEar.setRotationPoint(-1.0f, f1, -7.0f);
        this.wolfLeftEar = new Cube(16, 14);
        this.wolfLeftEar.addBox(1.0f, -5.0f, 0.0f, 2, 2, 1, expandAmount);
        this.wolfLeftEar.setRotationPoint(-1.0f, f1, -7.0f);
        this.wolfSnout = new Cube(0, 10);
        this.wolfSnout.addBox(-2.0f, 0.0f, -5.0f, 3, 3, 4, expandAmount);
        this.wolfSnout.setRotationPoint(-0.5f, f1, -7.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.render(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.wolfHeadMain.renderWithRotation(scale);
        this.wolfBody.render(scale);
        this.wolfLeg1.render(scale);
        this.wolfLeg2.render(scale);
        this.wolfLeg3.render(scale);
        this.wolfLeg4.render(scale);
        this.wolfRightEar.renderWithRotation(scale);
        this.wolfLeftEar.renderWithRotation(scale);
        this.wolfSnout.renderWithRotation(scale);
        this.wolfTail.renderWithRotation(scale);
        this.wolfMane.render(scale);
    }

    @Override
    public void setLivingAnimations(Mob mob, float limbSwing, float limbYaw, float partialTick) {
        float f3;
        WolfMob entitywolf = (WolfMob)mob;
        this.wolfTail.yRot = entitywolf.isWolfAngry() ? 0.0f : MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        if (entitywolf.isWolfSitting()) {
            this.wolfMane.setRotationPoint(-1.0f, 16.0f, -3.0f);
            this.wolfMane.xRot = 1.256637f;
            this.wolfMane.yRot = 0.0f;
            this.wolfBody.setRotationPoint(0.0f, 18.0f, 0.0f);
            this.wolfBody.xRot = 0.7853982f;
            this.wolfTail.setRotationPoint(-1.0f, 21.0f, 6.0f);
            this.wolfLeg1.setRotationPoint(-2.5f, 22.0f, 2.0f);
            this.wolfLeg1.xRot = 4.712389f;
            this.wolfLeg2.setRotationPoint(0.5f, 22.0f, 2.0f);
            this.wolfLeg2.xRot = 4.712389f;
            this.wolfLeg3.xRot = 5.811947f;
            this.wolfLeg3.setRotationPoint(-2.49f, 17.0f, -4.0f);
            this.wolfLeg4.xRot = 5.811947f;
            this.wolfLeg4.setRotationPoint(0.51f, 17.0f, -4.0f);
        } else {
            this.wolfBody.setRotationPoint(0.0f, 14.0f, 2.0f);
            this.wolfBody.xRot = 1.5707964f;
            this.wolfMane.setRotationPoint(-1.0f, 14.0f, -3.0f);
            this.wolfMane.xRot = this.wolfBody.xRot;
            this.wolfTail.setRotationPoint(-1.0f, 12.0f, 8.0f);
            this.wolfLeg1.setRotationPoint(-2.5f, 16.0f, 7.0f);
            this.wolfLeg2.setRotationPoint(0.5f, 16.0f, 7.0f);
            this.wolfLeg3.setRotationPoint(-2.5f, 16.0f, -4.0f);
            this.wolfLeg4.setRotationPoint(0.5f, 16.0f, -4.0f);
            this.wolfLeg1.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
            this.wolfLeg2.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
            this.wolfLeg3.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
            this.wolfLeg4.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        }
        this.wolfHeadMain.zRot = f3 = entitywolf.getInterestedAngle(partialTick) + entitywolf.getShakeAngle(partialTick, 0.0f);
        this.wolfRightEar.zRot = f3;
        this.wolfLeftEar.zRot = f3;
        this.wolfSnout.zRot = f3;
        this.wolfMane.zRot = entitywolf.getShakeAngle(partialTick, -0.08f);
        this.wolfBody.zRot = entitywolf.getShakeAngle(partialTick, -0.16f);
        this.wolfTail.zRot = entitywolf.getShakeAngle(partialTick, -0.2f);
        if (entitywolf.getWolfShaking()) {
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(entitywolf.getLightmapCoord(partialTick));
            } else if (!Global.accessor.isFullbrightEnabled()) {
                brightness = entitywolf.getBrightness(partialTick);
            }
            float f4 = brightness * entitywolf.getShadingWhileShaking(partialTick);
            GL11.glColor3f((float)f4, (float)f4, (float)f4);
        }
    }

    @Override
    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.wolfHeadMain.xRot = headPitch / 57.29578f;
        this.wolfRightEar.yRot = this.wolfHeadMain.yRot = headYaw / 57.29578f;
        this.wolfRightEar.xRot = this.wolfHeadMain.xRot;
        this.wolfLeftEar.yRot = this.wolfHeadMain.yRot;
        this.wolfLeftEar.xRot = this.wolfHeadMain.xRot;
        this.wolfSnout.yRot = this.wolfHeadMain.yRot;
        this.wolfSnout.xRot = this.wolfHeadMain.xRot;
        this.wolfTail.xRot = limbPitch;
    }
}

