/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.sound.NamedSoundRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundEntry {
    @NotNull
    public final NamedSoundRepository parent;
    @NotNull
    public final TexturePack pack;
    @NotNull
    public final String name;
    public final int weight;
    public final boolean shouldStream;
    @NotNull
    public final Type type;
    @Nullable
    protected File file;

    public SoundEntry(@NotNull NamedSoundRepository parent, @NotNull TexturePack pack, @NotNull String name, int weight, boolean shouldStream, @NotNull Type type) {
        this.parent = parent;
        this.pack = pack;
        this.name = name;
        this.weight = weight;
        this.shouldStream = shouldStream;
        this.type = type;
        this.file = type == Type.FILE ? new File(parent.rootFile, name) : null;
    }

    @Nullable
    public URL getURL() {
        if (this.file == null || !this.file.exists()) {
            return null;
        }
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            System.err.println("Error getting url for sound '" + this.name + "'");
            e.printStackTrace();
            return null;
        }
    }

    public static enum Type {
        FILE,
        EVENT;

    }
}

