/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.GoldMeshBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class GoldMeshBlock
extends EntityBlock {
    public GoldMeshBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.metal);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new GoldMeshBlockEntity();
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceOnSurface() {
        return true;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        GoldMeshBlockEntity meshGold = (GoldMeshBlockEntity)world.getBlockEntity(x, y, z);
        ItemStack heldItem = player.getHeldItem();
        boolean flag = meshGold.setFilterItem(player, heldItem);
        if (heldItem != null && heldItem.stackSize <= 0) {
            player.inventory.setItem(player.inventory.currentItem, null);
        }
        return flag;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        GoldMeshBlockEntity mesh = (GoldMeshBlockEntity)world.getBlockEntity(x, y, z);
        if (mesh.filterItem != null) {
            ItemEntity item = world.dropItem(x, y, z, mesh.filterItem);
            item.xd *= 0.5;
            item.yd *= 0.5;
            item.zd *= 0.5;
            item.pickupDelay = 0;
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public boolean collidesWithEntity(Entity entity, World world, int x, int y, int z) {
        if (entity instanceof ItemEntity) {
            GoldMeshBlockEntity mesh = (GoldMeshBlockEntity)world.getBlockEntity(x, y, z);
            if (mesh.filterItem == null) {
                return true;
            }
            ItemStack entityStack = ((ItemEntity)entity).item;
            return !entityStack.isItemEqual(mesh.filterItem);
        }
        return true;
    }
}

