/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class LampBlock
extends Block {
    public boolean isActive;

    public LampBlock(String key, String namespaceId, int id, boolean isActivated) {
        super(key, namespaceId, id, Material.stone);
        this.isActive = isActivated;
        this.setTicking(true);
    }

    @Override
    public int tickDelay() {
        return 2;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        boolean isPoweredByBlock;
        boolean bl = isPoweredByBlock = world.isBlockGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y, z);
        if (this.isActive) {
            if (!isPoweredByBlock) {
                world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_IDLE.id, world.getBlockMetadata(x, y, z));
            }
        } else if (isPoweredByBlock) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_ACTIVE.id, world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(Blocks.LAMP_IDLE, 1, meta)};
    }
}

