/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class OverlayPebblesBlock
extends Block {
    public OverlayPebblesBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y - 1, z);
        return block != null && block.blockMaterial.isSolid();
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        return this.canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return AABB.getTemporaryBB(x, y, z, x + 1, (float)y + 0.0625f, z + 1);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        this.minX = 0.0;
        this.minY = 0.0;
        this.minZ = 0.0;
        this.maxX = 1.0;
        this.maxY = 0.0625;
        this.maxZ = 1.0;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            return new ItemStack[]{new ItemStack(Items.AMMO_PEBBLE, 1)};
        }
        return new ItemStack[]{new ItemStack(Items.AMMO_PEBBLE, meta + 1)};
    }
}

