/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.TrapDoorBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class PaintedTrapDoorBlock
extends TrapDoorBlock {
    public PaintedTrapDoorBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material, false);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        int meta = world.getBlockMetadata(x, y, z);
        int colorBits = meta & 0xF0;
        meta = this.getMetaForDirection(mob.getHorizontalPlacementDirection(side, PlacementMode.SIDE));
        if (mob.getVerticalPlacementDirection(side, sideHeight) == Direction.UP) {
            meta |= 8;
        }
        world.setBlockMetadata(x, y, z, meta |= colorBits);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(Blocks.TRAPDOOR_PLANKS_PAINTED, 1, (meta >> 4 & 0xF) << 4)};
    }
}

