/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.SaplingBaseBlock;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeTaigaBushy;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeTaigaTall;

public class SaplingPineBlock
extends SaplingBaseBlock {
    public SaplingPineBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        super.updateTick(world, x, y, z, rand);
        int growthRate = 30;
        if (world.getBlockLightValue(x, y + 1, z) >= 9 && rand.nextInt(growthRate) == 0) {
            int l = world.getBlockMetadata(x, y, z);
            if ((l & 8) == 0) {
                world.setBlockMetadataWithNotify(x, y, z, l | 8);
            } else {
                this.growTree(world, x, y, z, rand);
            }
        }
    }

    @Override
    public void growTree(World world, int i, int j, int k, Random random) {
        WorldFeatureTreeTaigaTall treeBig = new WorldFeatureTreeTaigaTall(Blocks.LEAVES_PINE.id, Blocks.LOG_PINE.id);
        WorldFeatureTreeTaigaBushy treeSmall = new WorldFeatureTreeTaigaBushy(Blocks.LEAVES_PINE.id, Blocks.LOG_PINE.id);
        world.setBlock(i, j, k, 0);
        if (!((WorldFeature)treeSmall).place(world, random, i, j, k) && !((WorldFeature)treeBig).place(world, random, i, j, k)) {
            world.setBlock(i, j, k, this.id);
        }
    }
}

