/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.entry;

import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingDynamic;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.inventory.container.CraftingContainer;

public class RecipeEntryCloneMap
extends RecipeEntryCraftingDynamic {
    @Override
    public boolean matches(CraftingContainer crafting) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = crafting.getItemStackAt(x, y);
                if (stack == null) {
                    return false;
                }
                if (!(x == 1 && y == 1 ? stack.itemID != Items.MAP.id : stack.itemID != Items.PAPER.id)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(CraftingContainer crafting) {
        ItemStack output = crafting.getItemStackAt(1, 1).copy();
        output.stackSize = 2;
        return output;
    }

    @Override
    public int getRecipeSize() {
        return 9;
    }

    @Override
    public boolean matchesQuery(SearchQuery query) {
        return false;
    }

    @Override
    public ItemStack[] onCraftResult(CraftingContainer crafting) {
        for (int i = 0; i < crafting.getContainerSize(); ++i) {
            ItemStack stack = crafting.getItem(i);
            --stack.stackSize;
            if (stack.stackSize > 0) continue;
            crafting.setItem(i, null);
        }
        return null;
    }
}

