/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.entry;

import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingDynamic;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.inventory.container.CraftingContainer;

public class RecipeEntryLabel
extends RecipeEntryCraftingDynamic {
    @Override
    public ItemStack getCraftingResult(CraftingContainer inventorycrafting) {
        ItemStack labelStack = null;
        ItemStack otherItem = null;
        block0: for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Items.LABEL.id && labelStack == null) {
                    labelStack = stack;
                } else if (otherItem == null) {
                    otherItem = stack;
                }
                if (labelStack != null && otherItem != null) break block0;
            }
        }
        if (labelStack != null && otherItem != null) {
            ItemStack outStack = otherItem.copy();
            if (labelStack.hasCustomName()) {
                outStack.setCustomName(labelStack.getCustomName());
            }
            if (labelStack.hasCustomColor()) {
                outStack.setCustomColor(labelStack.getCustomColor());
            }
            outStack.stackSize = 1;
            return outStack;
        }
        return null;
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public boolean matches(CraftingContainer crafting) {
        ItemStack labelStack = null;
        ItemStack otherStack = null;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = crafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Items.LABEL.id) {
                    if (labelStack != null || !stack.hasCustomName()) {
                        return false;
                    }
                    labelStack = stack;
                    continue;
                }
                if (otherStack != null) {
                    return false;
                }
                otherStack = stack;
            }
        }
        if (labelStack == null || otherStack == null) {
            return false;
        }
        if (otherStack.itemID == Items.DYE.id && !labelStack.hasCustomColor()) {
            return false;
        }
        if (!labelStack.hasCustomName()) {
            return false;
        }
        if (otherStack.hasCustomName() && otherStack.getCustomName().equals(labelStack.getCustomName())) {
            if (labelStack.hasCustomColor()) {
                if (!otherStack.hasCustomColor()) {
                    return true;
                }
                return otherStack.getCustomColor() != labelStack.getCustomColor();
            }
            if (!otherStack.hasCustomColor() && !labelStack.hasCustomColor()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean matchesQuery(SearchQuery query) {
        return false;
    }

    @Override
    public ItemStack[] onCraftResult(CraftingContainer crafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = crafting.getItemStackAt(x, y);
                if (stack == null || stack.itemID == Items.LABEL.id) continue;
                --stack.stackSize;
                if (stack.stackSize > 0) continue;
                crafting.setSlotContentsAt(x, y, null);
            }
        }
        return returnStack;
    }
}

