/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.entry;

import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingDynamic;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.MapItem;
import net.minecraft.core.player.inventory.container.CraftingContainer;

public class RecipeEntryMapDuplication
extends RecipeEntryCraftingDynamic {
    @Override
    public ItemStack getCraftingResult(CraftingContainer inventorycrafting) {
        ItemStack map = null;
        int paperAmount = 0;
        for (int i = 0; i < inventorycrafting.getContainerSize(); ++i) {
            ItemStack s = inventorycrafting.getItem(i);
            if (s == null) continue;
            Item item = s.getItem();
            if (item == Items.MAP) {
                map = s;
                continue;
            }
            if (item != Items.PAPER) continue;
            ++paperAmount;
        }
        assert (map != null);
        ItemStack output = map.copy();
        output.stackSize += paperAmount;
        return output;
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public ItemStack[] onCraftResult(CraftingContainer inventorycrafting) {
        for (int i = 0; i < inventorycrafting.getContainerSize(); ++i) {
            inventorycrafting.setItem(i, null);
        }
        return new ItemStack[0];
    }

    @Override
    public boolean matches(CraftingContainer inventorycrafting) {
        ItemStack mapStack = null;
        boolean hasPaper = false;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Items.MAP.id) {
                    if (mapStack != null) {
                        return false;
                    }
                    mapStack = stack;
                    continue;
                }
                if (stack.itemID == Items.PAPER.id) {
                    hasPaper = true;
                    continue;
                }
                return false;
            }
        }
        if (mapStack == null) {
            return false;
        }
        if (!MapItem.hasInitialized(mapStack)) {
            return false;
        }
        return hasPaper;
    }

    @Override
    public boolean matchesQuery(SearchQuery query) {
        return false;
    }
}

