/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.LightningEntity;
import net.minecraft.core.entity.monster.Monster;
import net.minecraft.core.entity.monster.SkeletonMob;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;

public class CreeperMob
extends Monster {
    int timeSinceIgnited;
    int lastActiveTime;

    public CreeperMob(World world) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "creeper");
        this.scoreValue = 800;
        this.setSize(0.6f, 1.6f);
        this.mobDrops.add(new WeightedRandomLootObject(Items.SULPHUR.getDefaultStack(), 0, 2));
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, (byte)-1);
        this.entityData.define(17, (byte)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.entityData.getByte(17) == 1) {
            tag.putBoolean("powered", true);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(17, (byte)(tag.getBoolean("powered") ? 1 : 0));
    }

    @Override
    protected void attackBlockedEntity(Entity entity, float f) {
        if (this.world.isClientSide) {
            return;
        }
        if (this.timeSinceIgnited > 0) {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    @Override
    public void tick() {
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.world.isClientSide) {
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0 && !this.world.isClientSide) {
                this.world.playSoundAtEntity(null, this, "random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= 30) {
                this.timeSinceIgnited = 30;
            }
        }
        super.tick();
    }

    @Override
    protected String getHurtSound() {
        return "mob.creeper";
    }

    @Override
    protected String getDeathSound() {
        return "mob.creeperdeath";
    }

    @Override
    public void onDeath(Entity entityKilledBy) {
        super.onDeath(entityKilledBy);
        if (entityKilledBy instanceof SkeletonMob) {
            this.spawnAtLocation(Items.RECORD_13.id + this.random.nextInt(11), 1);
        }
    }

    @Override
    protected void attackEntity(Entity entity, float distance) {
        if (this.world.isClientSide) {
            return;
        }
        int i = this.getCreeperState();
        if (i <= 0 && distance < 3.0f || i > 0 && distance < 7.0f) {
            if (this.timeSinceIgnited == 0 && !this.world.isClientSide) {
                this.world.playSoundAtEntity(null, this, "random.fuse", 1.0f, 0.5f);
            }
            this.setCreeperState(1);
            ++this.timeSinceIgnited;
            if (this.timeSinceIgnited >= 30) {
                if (this.getPowered()) {
                    this.world.createExplosion(this, this.x, this.y, this.z, 6.0f);
                } else {
                    this.world.createExplosion(this, this.x, this.y, this.z, 3.0f);
                }
                this.remove();
            }
            this.hasAttacked = true;
        } else {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    public boolean getPowered() {
        return this.entityData.getByte(17) == 1;
    }

    public float getSwelling(float partialTick) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * partialTick) / 28.0f;
    }

    private int getCreeperState() {
        return this.entityData.getByte(16);
    }

    private void setCreeperState(int i) {
        this.entityData.set(16, (byte)i);
    }

    @Override
    public void thunderHit(LightningEntity bolt) {
        super.thunderHit(bolt);
        this.entityData.set(17, (byte)1);
    }
}

