/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.FishingBobberEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class FishingRodItem
extends Item {
    public FishingRodItem(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.setMaxDamage(196);
        this.setMaxStackSize(1);
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        if (entityplayer.bobberEntity != null) {
            int damage = entityplayer.bobberEntity.yoink();
            itemstack.damageItem(damage, entityplayer);
        } else {
            world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                world.entityJoinedWorld(new FishingBobberEntity(world, entityplayer));
            }
        }
        entityplayer.swingItem();
        return itemstack;
    }
}

