/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.RailBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.MinecartEntity;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class MinecartItem
extends Item {
    public final int minecartType;

    public MinecartItem(String name, String namespaceId, int id, int type) {
        super(name, namespaceId, id);
        this.setMaxStackSize(1);
        this.minecartType = type;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Block block = world.getBlock(blockX, blockY, blockZ);
        if (!(block instanceof RailBlock)) {
            return false;
        }
        if (!world.isClientSide) {
            world.entityJoinedWorld(new MinecartEntity(world, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.minecartType));
        }
        if (entityplayer.getGamemode().consumeBlocks()) {
            --itemstack.stackSize;
        }
        return true;
    }
}

