/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.BaseLeavesBlock;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;

public class ToolShearsItem
extends Item {
    public ToolShearsItem(String name, String namespaceId, int id, ToolMaterial material) {
        super(name, namespaceId, id);
        this.setMaxStackSize(1);
        this.setMaxDamage(material.getDurability());
    }

    public void onBlockSheared(Mob entity, ItemStack itemStack) {
        itemStack.damageItem(1, entity);
    }

    @Override
    public boolean canHarvestBlock(Mob entityLiving, ItemStack itemStack, Block block) {
        return block.hasTag(BlockTags.MINEABLE_BY_SHEARS);
    }

    @Override
    public float getStrVsBlock(ItemStack itemstack, Block block) {
        if (block.id == Blocks.COBWEB.id || block instanceof BaseLeavesBlock) {
            return 15.0f;
        }
        if (block.hasTag(BlockTags.MINEABLE_BY_SHEARS)) {
            return 10.0f;
        }
        return super.getStrVsBlock(itemstack, block);
    }
}

