/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockItem
extends Item {
    protected int blockID;

    public BlockItem(Block block) {
        super(block.namespaceID, block.id);
        this.blockID = block.id;
        this.setKey(block.getKey());
    }

    public Block getBlock() {
        return Block.blocksList[this.blockID];
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack stack, Player player, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        if (stack.stackSize <= 0) {
            return false;
        }
        if (!world.canPlaceInsideBlock(x, y, z)) {
            x += side.getOffsetX();
            y += side.getOffsetY();
            z += side.getOffsetZ();
        }
        if (y < 0 || y >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.blockID, x, y, z, false, side)) {
            Block block = Block.blocksList[this.blockID];
            int meta = this.getPlacedBlockMetadata(player, stack, world, x, y, z, side, xPlaced, yPlaced);
            if (world.setBlockAndMetadataWithNotify(x, y, z, this.blockID, meta)) {
                stack.consumeItem(player);
                block.onBlockPlacedByMob(world, x, y, z, side, player, yPlaced);
                world.playBlockSoundEffect(player, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block, EnumBlockSoundEffectType.PLACE);
                return true;
            }
        }
        return false;
    }

    public int getPlacedBlockMetadata(Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return Block.getBlock(this.blockID).getPlacedBlockMetadata(player, stack, world, x, y, z, side, xPlaced, yPlaced);
    }

    @Override
    public String getLanguageKey(ItemStack itemstack) {
        return Block.blocksList[this.blockID].getLanguageKey(itemstack.getMetadata());
    }

    @Override
    public String getKey() {
        return Block.blocksList[this.blockID].getKey();
    }
}

