/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.Commands;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class ClientCommandHandler
implements CommandHandler {
    public final Minecraft minecraft;

    public ClientCommandHandler(Minecraft minecraft) {
        this.minecraft = minecraft;
        Commands.initClientCommands(minecraft);
    }

    @Override
    public void sendMessageToAdmins(String msg) {
        if (this.minecraft.theWorld.getLevelData().getCheatsEnabled()) {
            this.minecraft.ingameGUI.addChatMessage(msg);
        }
    }

    @Override
    public void sendMessageToAllPlayers(String msg) {
        this.minecraft.ingameGUI.addChatMessage(msg);
    }

    @Override
    @Nullable
    public Player getPlayer(String name) {
        if (this.minecraft.thePlayer.username.equalsIgnoreCase(name)) {
            return this.minecraft.thePlayer;
        }
        return null;
    }

    @Override
    public void sendMessageToPlayer(Player player, String msg) {
        if (player == this.minecraft.thePlayer) {
            this.minecraft.ingameGUI.addChatMessage(msg);
        }
    }

    @Override
    public boolean playerExists(String name) {
        return name.equalsIgnoreCase(this.minecraft.thePlayer.username);
    }

    @Override
    public void sendCommandFeedback(CommandSender sender, String message) {
        sender.sendMessage(message);
    }

    @Override
    public World getWorld(int dimension) {
        return this.minecraft.theWorld;
    }
}

