/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Utils;
import net.minecraft.core.world.World;

public class LocationTarget {
    private CommandHandler handler;
    private CommandSender sender;
    private World world;
    private Entity locationEntity;
    private Double x;
    private Double y;
    private Double z;
    public static String numberChars = "0123456789.-~";

    public LocationTarget(CommandHandler handler, CommandSender sender) {
        this.handler = handler;
        this.sender = sender;
        if (sender.isPlayer()) {
            this.world = sender.getPlayer().world;
            this.locationEntity = sender.getPlayer();
            this.x = sender.getPlayer().x;
            this.y = sender.getPlayer().y;
            this.z = sender.getPlayer().z;
        }
    }

    public World getWorld() {
        if (this.world == null) {
            throw new CommandError("Must be used by a player, or a dimension ID must be provided!");
        }
        return this.world;
    }

    private void checkPosition() {
        if (this.x == null || this.y == null || this.z == null) {
            throw new CommandError("Must be used by a player, or coordinates must be provided!");
        }
    }

    public int parse(String[] args, int offset) {
        try {
            if (!LocationTarget.isNumber(args[offset])) {
                Player player = this.handler.getPlayer(args[offset]);
                if (player != null) {
                    this.setLocation(player);
                    return 1;
                }
                throw new CommandError("Player \"" + args[offset] + "\" not found!");
            }
            if (args.length < offset + 3) {
                throw new CommandError("Not enough arguments");
            }
            this.locationEntity = null;
            this.x = this.parse(this.x, args[offset + 0]);
            this.y = this.parse(this.y, args[offset + 1]);
            this.z = this.parse(this.z, args[offset + 2]);
            return 3;
        }
        catch (CommandError e) {
            throw new CommandError("Error parsing location: " + e.getMessage());
        }
        catch (Exception e) {
            throw new CommandError("Error parsing location");
        }
    }

    private Double parse(Double pos, String str) {
        double newPos = 0.0;
        newPos = str.equals("~") ? (pos == null ? 0.0 : pos) : (str.startsWith("~") ? (pos == null ? LocationTarget.parseDouble(str.substring(1)) : pos + LocationTarget.parseDouble(str.substring(1))) : LocationTarget.parseDouble(str));
        return newPos;
    }

    private void setLocation(Entity entity) {
        this.locationEntity = entity;
        this.x = entity.x;
        this.y = entity.y;
        this.z = entity.z;
    }

    public double getX() {
        this.checkPosition();
        return this.x;
    }

    public double getY() {
        this.checkPosition();
        return this.y;
    }

    public double getZ() {
        this.checkPosition();
        return this.z;
    }

    public int getBlockX() {
        this.checkPosition();
        return MathHelper.floor(this.x);
    }

    public int getBlockY() {
        this.checkPosition();
        return MathHelper.floor(this.y);
    }

    public int getBlockZ() {
        this.checkPosition();
        return MathHelper.floor(this.z);
    }

    public boolean isLocationEntity() {
        return this.locationEntity != null && this.locationEntity instanceof Player;
    }

    public String getLocationEntityName() {
        if (this.locationEntity == null) {
            return null;
        }
        if (this.locationEntity instanceof Player) {
            Player entityPlayer = (Player)this.locationEntity;
            return entityPlayer.username;
        }
        return null;
    }

    public String toString() {
        if (this.x != null && this.y != null && this.z != null) {
            return "x: " + Utils.floor10(this.x) + " y: " + Utils.floor10(this.y) + " z: " + Utils.floor10(this.z);
        }
        return null;
    }

    public static boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (numberChars.indexOf(str.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static double parseDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception e) {
            throw new CommandError("Not a number: \"" + str + "\"");
        }
    }
}

