/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;

public class ServerPlayerCommandSender
extends PlayerCommandSender {
    public final MinecraftServer server;
    public final ServerPlayer player;

    public ServerPlayerCommandSender(MinecraftServer server, ServerPlayer player) {
        this.player = player;
        this.server = server;
    }

    @Override
    public boolean isAdmin() {
        return this.server.playerList.isOp(this.player.username);
    }

    @Override
    public void sendMessage(String string) {
        this.player.playerNetServerHandler.sendPacket(new ChatPacket(string, AES.keyChain.get(this.player.username)));
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public ServerPlayer getPlayerMP() {
        return this.player;
    }

    @Override
    public String getName() {
        return this.player.getDisplayName();
    }

    @Override
    public World getWorld() {
        return this.player.world;
    }
}

