/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.world.World;

public class ChunkCommand
extends Command {
    public ChunkCommand() {
        super("chunk", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args[0].equalsIgnoreCase("regen")) {
            World world = null;
            int x = Integer.MAX_VALUE;
            int z = Integer.MAX_VALUE;
            if (sender instanceof PlayerCommandSender) {
                world = sender.getPlayer().world;
                if (args.length == 3) {
                    x = args[1].equalsIgnoreCase("~") ? sender.getPlayer().chunkCoordX : Integer.parseInt(args[1]);
                    z = args[2].equalsIgnoreCase("~") ? sender.getPlayer().chunkCoordZ : Integer.parseInt(args[2]);
                }
            }
            if (handler instanceof ServerCommandHandler && args.length == 4) {
                ServerCommandHandler server = (ServerCommandHandler)handler;
                int dim = Integer.parseInt(args[3]);
                world = server.minecraftServer.getDimensionWorld(dim);
                x = Integer.parseInt(args[1]);
                z = Integer.parseInt(args[2]);
            }
            if (world == null) {
                throw new CommandError("Must be used by a player, or a dimension must be defined!");
            }
            if (x == Integer.MAX_VALUE || z == Integer.MAX_VALUE) {
                throw new CommandError("Please provide a valid value for X/Z!");
            }
            world.getChunkProvider().regenerateChunk(x, z);
            return true;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/chunk regen <x> <z>");
            sender.sendMessage("/chunk regen ~ ~");
        } else {
            sender.sendMessage("/chunk regen <x> <z> <dimension>");
        }
    }
}

