/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.Commands;
import net.minecraft.core.net.command.ConsoleCommandSender;
import net.minecraft.core.net.command.TextFormatting;

public class HelpCommand
extends Command {
    public HelpCommand() {
        super("help", "?");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 1) {
            Command command = Commands.getCommand(args[0]);
            if (command == null) {
                throw new CommandError("Can't find command: \"" + args[0] + "\"");
            }
            if (!sender.isAdmin() && command.opRequired(args)) {
                throw new CommandError("You don't have permission to use this command!");
            }
            if (command.getNames().size() > 1) {
                StringBuilder aliasStr = new StringBuilder();
                aliasStr.append(TextFormatting.LIGHT_GRAY).append("Aliases: ");
                for (int i = 0; i < command.getNames().size(); ++i) {
                    if (i > 0) {
                        aliasStr.append(", ");
                    }
                    aliasStr.append(command.getNames().get(i));
                }
                sender.sendMessage(aliasStr.toString());
            }
            sender.sendMessage(TextFormatting.LIGHT_GRAY + "Syntax: ");
            command.sendCommandSyntax(handler, sender);
            return true;
        }
        StringBuilder commandsString = new StringBuilder();
        ArrayList<Command> commandList = new ArrayList<Command>(Commands.commands);
        commandList.sort(Comparator.comparing(Command::getName));
        for (Command command : commandList) {
            if (!sender.isAdmin() && command.opRequired(null)) continue;
            if (sender instanceof ConsoleCommandSender) {
                commandsString.append("\n").append("*    ");
            } else {
                commandsString.append(", ");
            }
            commandsString.append(command.getName());
        }
        commandsString = new StringBuilder(TextFormatting.LIGHT_GRAY + "Commands: " + TextFormatting.WHITE + commandsString.substring(2));
        sender.sendMessage(commandsString.toString());
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/help");
    }
}

