/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.servercommands;

import java.util.ArrayList;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;

public class ScoreboardCommand
extends ServerCommand {
    public ScoreboardCommand(MinecraftServer server) {
        super(server, "scoreboard", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        StringBuilder scoreBoardMessage = new StringBuilder();
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(this.server.playerList.playerEntities);
        players.sort((o1, o2) -> o2.score - o1.score);
        for (int i = 0; i < players.size(); ++i) {
            if (i > 0) {
                scoreBoardMessage.append(", ");
            }
            ServerPlayer player = (ServerPlayer)players.get(i);
            scoreBoardMessage.append(player.getDisplayName()).append(": ").append(TextFormatting.YELLOW).append(player.score).append("pts").append(TextFormatting.WHITE);
        }
        sender.sendMessage(scoreBoardMessage.toString());
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/scoreboard");
    }
}

