/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.entity.entries;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.FishingBobberEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.entity.ITrackedEntry;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.packet.AddEntityPacket;
import net.minecraft.core.world.World;
import net.minecraft.server.entity.EntityTracker;
import net.minecraft.server.entity.EntityTrackerEntry;
import org.jetbrains.annotations.NotNull;

public class BobberNetEntry
implements IVehicleEntry<FishingBobberEntity>,
ITrackedEntry<FishingBobberEntity> {
    @Override
    @NotNull
    public Class<FishingBobberEntity> getAppliedClass() {
        return FishingBobberEntity.class;
    }

    @Override
    public int getTrackingDistance() {
        return 64;
    }

    @Override
    public int getPacketDelay() {
        return 5;
    }

    @Override
    public boolean sendMotionUpdates() {
        return true;
    }

    @Override
    public void onEntityTracked(EntityTracker tracker, EntityTrackerEntry trackerEntry, FishingBobberEntity trackedObject) {
    }

    @Override
    public Entity getEntity(World world, double x, double y, double z, int metadata, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        FishingBobberEntity bobber = new FishingBobberEntity(world, x, y, z);
        if (owner != null) {
            bobber.owner = (Player)owner;
            ((Player)owner).bobberEntity = bobber;
        }
        return bobber;
    }

    @Override
    public AddEntityPacket getSpawnPacket(EntityTrackerEntry tracker, FishingBobberEntity bobber) {
        return new AddEntityPacket(bobber, 0, bobber.owner == null ? -1 : bobber.owner.id);
    }
}

